package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1UserRoleOperationFluentImpl<A extends V1alpha1UserRoleOperationFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1UserRoleOperationFluent<A>{

    private String operation;
    private V1alpha1RoleMetaBuilder role;
    private V1alpha1UserMetaBuilder user;

    public V1alpha1UserRoleOperationFluentImpl(){
    }
    public V1alpha1UserRoleOperationFluentImpl(V1alpha1UserRoleOperation instance){
            this.withOperation(instance.getOperation());

            this.withRole(instance.getRole());

            this.withUser(instance.getUser());

    }

    public String getOperation(){
            return this.operation;
    }

    public A withOperation(String operation){
            this.operation=operation; return (A) this;
    }

    public Boolean hasOperation(){
            return this.operation != null;
    }

    public A withNewOperation(String arg1){
            return (A)withOperation(new String(arg1));
    }

    public A withNewOperation(StringBuilder arg1){
            return (A)withOperation(new String(arg1));
    }

    public A withNewOperation(StringBuffer arg1){
            return (A)withOperation(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRole instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1RoleMeta getRole(){
            return this.role!=null?this.role.build():null;
    }

    public V1alpha1RoleMeta buildRole(){
            return this.role!=null?this.role.build():null;
    }

    public A withRole(V1alpha1RoleMeta role){
            _visitables.get("role").remove(this.role);
            if (role!=null){ this.role= new V1alpha1RoleMetaBuilder(role); _visitables.get("role").add(this.role);} return (A) this;
    }

    public Boolean hasRole(){
            return this.role != null;
    }

    public V1alpha1UserRoleOperationFluent.RoleNested<A> withNewRole(){
            return new RoleNestedImpl();
    }

    public V1alpha1UserRoleOperationFluent.RoleNested<A> withNewRoleLike(V1alpha1RoleMeta item){
            return new RoleNestedImpl(item);
    }

    public V1alpha1UserRoleOperationFluent.RoleNested<A> editRole(){
            return withNewRoleLike(getRole());
    }

    public V1alpha1UserRoleOperationFluent.RoleNested<A> editOrNewRole(){
            return withNewRoleLike(getRole() != null ? getRole(): new V1alpha1RoleMetaBuilder().build());
    }

    public V1alpha1UserRoleOperationFluent.RoleNested<A> editOrNewRoleLike(V1alpha1RoleMeta item){
            return withNewRoleLike(getRole() != null ? getRole(): item);
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1UserMeta getUser(){
            return this.user!=null?this.user.build():null;
    }

    public V1alpha1UserMeta buildUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(V1alpha1UserMeta user){
            _visitables.get("user").remove(this.user);
            if (user!=null){ this.user= new V1alpha1UserMetaBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public V1alpha1UserRoleOperationFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public V1alpha1UserRoleOperationFluent.UserNested<A> withNewUserLike(V1alpha1UserMeta item){
            return new UserNestedImpl(item);
    }

    public V1alpha1UserRoleOperationFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public V1alpha1UserRoleOperationFluent.UserNested<A> editOrNewUser(){
            return withNewUserLike(getUser() != null ? getUser(): new V1alpha1UserMetaBuilder().build());
    }

    public V1alpha1UserRoleOperationFluent.UserNested<A> editOrNewUserLike(V1alpha1UserMeta item){
            return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1UserRoleOperationFluentImpl that = (V1alpha1UserRoleOperationFluentImpl) o;
            if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
            if (role != null ? !role.equals(that.role) :that.role != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class RoleNestedImpl<N> extends V1alpha1RoleMetaFluentImpl<V1alpha1UserRoleOperationFluent.RoleNested<N>> implements V1alpha1UserRoleOperationFluent.RoleNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1RoleMetaBuilder builder;
    
            RoleNestedImpl(V1alpha1RoleMeta item){
                    this.builder = new V1alpha1RoleMetaBuilder(this, item);
            }
            RoleNestedImpl(){
                    this.builder = new V1alpha1RoleMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1UserRoleOperationFluentImpl.this.withRole(builder.build());
    }
    public N endRole(){
            return and();
    }

}
    public class UserNestedImpl<N> extends V1alpha1UserMetaFluentImpl<V1alpha1UserRoleOperationFluent.UserNested<N>> implements V1alpha1UserRoleOperationFluent.UserNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1UserMetaBuilder builder;
    
            UserNestedImpl(V1alpha1UserMeta item){
                    this.builder = new V1alpha1UserMetaBuilder(this, item);
            }
            UserNestedImpl(){
                    this.builder = new V1alpha1UserMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1UserRoleOperationFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
