package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1ToolTypeSpecFluentImpl<A extends V1alpha1ToolTypeSpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ToolTypeSpecFluent<A>{

    private String apiPath;
    private V1alpha1ToolTypeSpecDisplayNameBuilder description;
    private V1alpha1ToolTypeSpecDisplayNameBuilder displayName;
    private Boolean enabled;
    private Boolean enterprise;
    private String host;
    private String html;
    private String kind;
    private Boolean _public;
    private String recommendedVersion;
    private Boolean roleSyncEnabled;
    private List<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder> supportedSecretTypes;
    private List<V1alpha1ToolCategoryRefBuilder> toolCategory;
    private String type;

    public V1alpha1ToolTypeSpecFluentImpl(){
    }
    public V1alpha1ToolTypeSpecFluentImpl(V1alpha1ToolTypeSpec instance){
            this.withApiPath(instance.getApiPath());

            this.withDescription(instance.getDescription());

            this.withDisplayName(instance.getDisplayName());

            this.withEnabled(instance.isEnabled());

            this.withEnterprise(instance.isEnterprise());

            this.withHost(instance.getHost());

            this.withHtml(instance.getHtml());

            this.withKind(instance.getKind());

            this.withPublic(instance.isPublic());

            this.withRecommendedVersion(instance.getRecommendedVersion());

            this.withRoleSyncEnabled(instance.isRoleSyncEnabled());

            this.withSupportedSecretTypes(instance.getSupportedSecretTypes());

            this.withToolCategory(instance.getToolCategory());

            this.withType(instance.getType());

    }

    public String getApiPath(){
            return this.apiPath;
    }

    public A withApiPath(String apiPath){
            this.apiPath=apiPath; return (A) this;
    }

    public Boolean hasApiPath(){
            return this.apiPath != null;
    }

    public A withNewApiPath(String arg1){
            return (A)withApiPath(new String(arg1));
    }

    public A withNewApiPath(StringBuilder arg1){
            return (A)withApiPath(new String(arg1));
    }

    public A withNewApiPath(StringBuffer arg1){
            return (A)withApiPath(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDescription instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ToolTypeSpecDisplayName getDescription(){
            return this.description!=null?this.description.build():null;
    }

    public V1alpha1ToolTypeSpecDisplayName buildDescription(){
            return this.description!=null?this.description.build():null;
    }

    public A withDescription(V1alpha1ToolTypeSpecDisplayName description){
            _visitables.get("description").remove(this.description);
            if (description!=null){ this.description= new V1alpha1ToolTypeSpecDisplayNameBuilder(description); _visitables.get("description").add(this.description);} return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public V1alpha1ToolTypeSpecFluent.DescriptionNested<A> withNewDescription(){
            return new DescriptionNestedImpl();
    }

    public V1alpha1ToolTypeSpecFluent.DescriptionNested<A> withNewDescriptionLike(V1alpha1ToolTypeSpecDisplayName item){
            return new DescriptionNestedImpl(item);
    }

    public V1alpha1ToolTypeSpecFluent.DescriptionNested<A> editDescription(){
            return withNewDescriptionLike(getDescription());
    }

    public V1alpha1ToolTypeSpecFluent.DescriptionNested<A> editOrNewDescription(){
            return withNewDescriptionLike(getDescription() != null ? getDescription(): new V1alpha1ToolTypeSpecDisplayNameBuilder().build());
    }

    public V1alpha1ToolTypeSpecFluent.DescriptionNested<A> editOrNewDescriptionLike(V1alpha1ToolTypeSpecDisplayName item){
            return withNewDescriptionLike(getDescription() != null ? getDescription(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDisplayName instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ToolTypeSpecDisplayName getDisplayName(){
            return this.displayName!=null?this.displayName.build():null;
    }

    public V1alpha1ToolTypeSpecDisplayName buildDisplayName(){
            return this.displayName!=null?this.displayName.build():null;
    }

    public A withDisplayName(V1alpha1ToolTypeSpecDisplayName displayName){
            _visitables.get("displayName").remove(this.displayName);
            if (displayName!=null){ this.displayName= new V1alpha1ToolTypeSpecDisplayNameBuilder(displayName); _visitables.get("displayName").add(this.displayName);} return (A) this;
    }

    public Boolean hasDisplayName(){
            return this.displayName != null;
    }

    public V1alpha1ToolTypeSpecFluent.DisplayNameNested<A> withNewDisplayName(){
            return new DisplayNameNestedImpl();
    }

    public V1alpha1ToolTypeSpecFluent.DisplayNameNested<A> withNewDisplayNameLike(V1alpha1ToolTypeSpecDisplayName item){
            return new DisplayNameNestedImpl(item);
    }

    public V1alpha1ToolTypeSpecFluent.DisplayNameNested<A> editDisplayName(){
            return withNewDisplayNameLike(getDisplayName());
    }

    public V1alpha1ToolTypeSpecFluent.DisplayNameNested<A> editOrNewDisplayName(){
            return withNewDisplayNameLike(getDisplayName() != null ? getDisplayName(): new V1alpha1ToolTypeSpecDisplayNameBuilder().build());
    }

    public V1alpha1ToolTypeSpecFluent.DisplayNameNested<A> editOrNewDisplayNameLike(V1alpha1ToolTypeSpecDisplayName item){
            return withNewDisplayNameLike(getDisplayName() != null ? getDisplayName(): item);
    }

    public Boolean isEnabled(){
            return this.enabled;
    }

    public A withEnabled(Boolean enabled){
            this.enabled=enabled; return (A) this;
    }

    public Boolean hasEnabled(){
            return this.enabled != null;
    }

    public A withNewEnabled(String arg1){
            return (A)withEnabled(new Boolean(arg1));
    }

    public A withNewEnabled(boolean arg1){
            return (A)withEnabled(new Boolean(arg1));
    }

    public Boolean isEnterprise(){
            return this.enterprise;
    }

    public A withEnterprise(Boolean enterprise){
            this.enterprise=enterprise; return (A) this;
    }

    public Boolean hasEnterprise(){
            return this.enterprise != null;
    }

    public A withNewEnterprise(String arg1){
            return (A)withEnterprise(new Boolean(arg1));
    }

    public A withNewEnterprise(boolean arg1){
            return (A)withEnterprise(new Boolean(arg1));
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public String getHtml(){
            return this.html;
    }

    public A withHtml(String html){
            this.html=html; return (A) this;
    }

    public Boolean hasHtml(){
            return this.html != null;
    }

    public A withNewHtml(String arg1){
            return (A)withHtml(new String(arg1));
    }

    public A withNewHtml(StringBuilder arg1){
            return (A)withHtml(new String(arg1));
    }

    public A withNewHtml(StringBuffer arg1){
            return (A)withHtml(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public Boolean isPublic(){
            return this._public;
    }

    public A withPublic(Boolean _public){
            this._public=_public; return (A) this;
    }

    public Boolean hasPublic(){
            return this._public != null;
    }

    public A withNewPublic(String arg1){
            return (A)withPublic(new Boolean(arg1));
    }

    public A withNewPublic(boolean arg1){
            return (A)withPublic(new Boolean(arg1));
    }

    public String getRecommendedVersion(){
            return this.recommendedVersion;
    }

    public A withRecommendedVersion(String recommendedVersion){
            this.recommendedVersion=recommendedVersion; return (A) this;
    }

    public Boolean hasRecommendedVersion(){
            return this.recommendedVersion != null;
    }

    public A withNewRecommendedVersion(String arg1){
            return (A)withRecommendedVersion(new String(arg1));
    }

    public A withNewRecommendedVersion(StringBuilder arg1){
            return (A)withRecommendedVersion(new String(arg1));
    }

    public A withNewRecommendedVersion(StringBuffer arg1){
            return (A)withRecommendedVersion(new String(arg1));
    }

    public Boolean isRoleSyncEnabled(){
            return this.roleSyncEnabled;
    }

    public A withRoleSyncEnabled(Boolean roleSyncEnabled){
            this.roleSyncEnabled=roleSyncEnabled; return (A) this;
    }

    public Boolean hasRoleSyncEnabled(){
            return this.roleSyncEnabled != null;
    }

    public A withNewRoleSyncEnabled(String arg1){
            return (A)withRoleSyncEnabled(new Boolean(arg1));
    }

    public A withNewRoleSyncEnabled(boolean arg1){
            return (A)withRoleSyncEnabled(new Boolean(arg1));
    }

    public A addToSupportedSecretTypes(int index,V1alpha1ToolTypeSpecSupportedSecretTypes item){
            if (this.supportedSecretTypes == null) {this.supportedSecretTypes = new ArrayList<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder>();}
            V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);_visitables.get("supportedSecretTypes").add(index >= 0 ? index : _visitables.get("supportedSecretTypes").size(), builder);this.supportedSecretTypes.add(index >= 0 ? index : supportedSecretTypes.size(), builder); return (A)this;
    }

    public A setToSupportedSecretTypes(int index,V1alpha1ToolTypeSpecSupportedSecretTypes item){
            if (this.supportedSecretTypes == null) {this.supportedSecretTypes = new ArrayList<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder>();}
            V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);
            if (index < 0 || index >= _visitables.get("supportedSecretTypes").size()) { _visitables.get("supportedSecretTypes").add(builder); } else { _visitables.get("supportedSecretTypes").set(index, builder);}
            if (index < 0 || index >= supportedSecretTypes.size()) { supportedSecretTypes.add(builder); } else { supportedSecretTypes.set(index, builder);}
             return (A)this;
    }

    public A addToSupportedSecretTypes(V1alpha1ToolTypeSpecSupportedSecretTypes... items){
            if (this.supportedSecretTypes == null) {this.supportedSecretTypes = new ArrayList<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder>();}
            for (V1alpha1ToolTypeSpecSupportedSecretTypes item : items) {V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);_visitables.get("supportedSecretTypes").add(builder);this.supportedSecretTypes.add(builder);} return (A)this;
    }

    public A addAllToSupportedSecretTypes(Collection<V1alpha1ToolTypeSpecSupportedSecretTypes> items){
            if (this.supportedSecretTypes == null) {this.supportedSecretTypes = new ArrayList<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder>();}
            for (V1alpha1ToolTypeSpecSupportedSecretTypes item : items) {V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);_visitables.get("supportedSecretTypes").add(builder);this.supportedSecretTypes.add(builder);} return (A)this;
    }

    public A removeFromSupportedSecretTypes(V1alpha1ToolTypeSpecSupportedSecretTypes... items){
            for (V1alpha1ToolTypeSpecSupportedSecretTypes item : items) {V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);_visitables.get("supportedSecretTypes").remove(builder);if (this.supportedSecretTypes != null) {this.supportedSecretTypes.remove(builder);}} return (A)this;
    }

    public A removeAllFromSupportedSecretTypes(Collection<V1alpha1ToolTypeSpecSupportedSecretTypes> items){
            for (V1alpha1ToolTypeSpecSupportedSecretTypes item : items) {V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(item);_visitables.get("supportedSecretTypes").remove(builder);if (this.supportedSecretTypes != null) {this.supportedSecretTypes.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSupportedSecretTypes instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1ToolTypeSpecSupportedSecretTypes> getSupportedSecretTypes(){
            return build(supportedSecretTypes);
    }

    public List<V1alpha1ToolTypeSpecSupportedSecretTypes> buildSupportedSecretTypes(){
            return build(supportedSecretTypes);
    }

    public V1alpha1ToolTypeSpecSupportedSecretTypes buildSupportedSecretType(int index){
            return this.supportedSecretTypes.get(index).build();
    }

    public V1alpha1ToolTypeSpecSupportedSecretTypes buildFirstSupportedSecretType(){
            return this.supportedSecretTypes.get(0).build();
    }

    public V1alpha1ToolTypeSpecSupportedSecretTypes buildLastSupportedSecretType(){
            return this.supportedSecretTypes.get(supportedSecretTypes.size() - 1).build();
    }

    public V1alpha1ToolTypeSpecSupportedSecretTypes buildMatchingSupportedSecretType(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder> predicate){
            for (V1alpha1ToolTypeSpecSupportedSecretTypesBuilder item: supportedSecretTypes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSupportedSecretType(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder> predicate){
            for (V1alpha1ToolTypeSpecSupportedSecretTypesBuilder item: supportedSecretTypes) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSupportedSecretTypes(List<V1alpha1ToolTypeSpecSupportedSecretTypes> supportedSecretTypes){
            if (this.supportedSecretTypes != null) { _visitables.get("supportedSecretTypes").removeAll(this.supportedSecretTypes);}
            if (supportedSecretTypes != null) {this.supportedSecretTypes = new ArrayList<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder>(); for (V1alpha1ToolTypeSpecSupportedSecretTypes item : supportedSecretTypes){this.addToSupportedSecretTypes(item);}} else { this.supportedSecretTypes = null;} return (A) this;
    }

    public A withSupportedSecretTypes(V1alpha1ToolTypeSpecSupportedSecretTypes... supportedSecretTypes){
            if (this.supportedSecretTypes != null) {this.supportedSecretTypes.clear();}
            if (supportedSecretTypes != null) {for (V1alpha1ToolTypeSpecSupportedSecretTypes item :supportedSecretTypes){ this.addToSupportedSecretTypes(item);}} return (A) this;
    }

    public Boolean hasSupportedSecretTypes(){
            return supportedSecretTypes != null && !supportedSecretTypes.isEmpty();
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> addNewSupportedSecretType(){
            return new SupportedSecretTypesNestedImpl();
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> addNewSupportedSecretTypeLike(V1alpha1ToolTypeSpecSupportedSecretTypes item){
            return new SupportedSecretTypesNestedImpl(-1, item);
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> setNewSupportedSecretTypeLike(int index,V1alpha1ToolTypeSpecSupportedSecretTypes item){
            return new SupportedSecretTypesNestedImpl(index, item);
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> editSupportedSecretType(int index){
            if (supportedSecretTypes.size() <= index) throw new RuntimeException("Can't edit supportedSecretTypes. Index exceeds size.");
            return setNewSupportedSecretTypeLike(index, buildSupportedSecretType(index));
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> editFirstSupportedSecretType(){
            if (supportedSecretTypes.size() == 0) throw new RuntimeException("Can't edit first supportedSecretTypes. The list is empty.");
            return setNewSupportedSecretTypeLike(0, buildSupportedSecretType(0));
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> editLastSupportedSecretType(){
            int index = supportedSecretTypes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last supportedSecretTypes. The list is empty.");
            return setNewSupportedSecretTypeLike(index, buildSupportedSecretType(index));
    }

    public V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<A> editMatchingSupportedSecretType(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolTypeSpecSupportedSecretTypesBuilder> predicate){
            int index = -1;
            for (int i=0;i<supportedSecretTypes.size();i++) { 
            if (predicate.apply(supportedSecretTypes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching supportedSecretTypes. No match found.");
            return setNewSupportedSecretTypeLike(index, buildSupportedSecretType(index));
    }

    public A addToToolCategory(int index,V1alpha1ToolCategoryRef item){
            if (this.toolCategory == null) {this.toolCategory = new ArrayList<V1alpha1ToolCategoryRefBuilder>();}
            V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);_visitables.get("toolCategory").add(index >= 0 ? index : _visitables.get("toolCategory").size(), builder);this.toolCategory.add(index >= 0 ? index : toolCategory.size(), builder); return (A)this;
    }

    public A setToToolCategory(int index,V1alpha1ToolCategoryRef item){
            if (this.toolCategory == null) {this.toolCategory = new ArrayList<V1alpha1ToolCategoryRefBuilder>();}
            V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);
            if (index < 0 || index >= _visitables.get("toolCategory").size()) { _visitables.get("toolCategory").add(builder); } else { _visitables.get("toolCategory").set(index, builder);}
            if (index < 0 || index >= toolCategory.size()) { toolCategory.add(builder); } else { toolCategory.set(index, builder);}
             return (A)this;
    }

    public A addToToolCategory(V1alpha1ToolCategoryRef... items){
            if (this.toolCategory == null) {this.toolCategory = new ArrayList<V1alpha1ToolCategoryRefBuilder>();}
            for (V1alpha1ToolCategoryRef item : items) {V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);_visitables.get("toolCategory").add(builder);this.toolCategory.add(builder);} return (A)this;
    }

    public A addAllToToolCategory(Collection<V1alpha1ToolCategoryRef> items){
            if (this.toolCategory == null) {this.toolCategory = new ArrayList<V1alpha1ToolCategoryRefBuilder>();}
            for (V1alpha1ToolCategoryRef item : items) {V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);_visitables.get("toolCategory").add(builder);this.toolCategory.add(builder);} return (A)this;
    }

    public A removeFromToolCategory(V1alpha1ToolCategoryRef... items){
            for (V1alpha1ToolCategoryRef item : items) {V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);_visitables.get("toolCategory").remove(builder);if (this.toolCategory != null) {this.toolCategory.remove(builder);}} return (A)this;
    }

    public A removeAllFromToolCategory(Collection<V1alpha1ToolCategoryRef> items){
            for (V1alpha1ToolCategoryRef item : items) {V1alpha1ToolCategoryRefBuilder builder = new V1alpha1ToolCategoryRefBuilder(item);_visitables.get("toolCategory").remove(builder);if (this.toolCategory != null) {this.toolCategory.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildToolCategory instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1ToolCategoryRef> getToolCategory(){
            return build(toolCategory);
    }

    public List<V1alpha1ToolCategoryRef> buildToolCategory(){
            return build(toolCategory);
    }

    public V1alpha1ToolCategoryRef buildToolCategory(int index){
            return this.toolCategory.get(index).build();
    }

    public V1alpha1ToolCategoryRef buildFirstToolCategory(){
            return this.toolCategory.get(0).build();
    }

    public V1alpha1ToolCategoryRef buildLastToolCategory(){
            return this.toolCategory.get(toolCategory.size() - 1).build();
    }

    public V1alpha1ToolCategoryRef buildMatchingToolCategory(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolCategoryRefBuilder> predicate){
            for (V1alpha1ToolCategoryRefBuilder item: toolCategory) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingToolCategory(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolCategoryRefBuilder> predicate){
            for (V1alpha1ToolCategoryRefBuilder item: toolCategory) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withToolCategory(List<V1alpha1ToolCategoryRef> toolCategory){
            if (this.toolCategory != null) { _visitables.get("toolCategory").removeAll(this.toolCategory);}
            if (toolCategory != null) {this.toolCategory = new ArrayList<V1alpha1ToolCategoryRefBuilder>(); for (V1alpha1ToolCategoryRef item : toolCategory){this.addToToolCategory(item);}} else { this.toolCategory = null;} return (A) this;
    }

    public A withToolCategory(V1alpha1ToolCategoryRef... toolCategory){
            if (this.toolCategory != null) {this.toolCategory.clear();}
            if (toolCategory != null) {for (V1alpha1ToolCategoryRef item :toolCategory){ this.addToToolCategory(item);}} return (A) this;
    }

    public Boolean hasToolCategory(){
            return toolCategory != null && !toolCategory.isEmpty();
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> addNewToolCategory(){
            return new ToolCategoryNestedImpl();
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> addNewToolCategoryLike(V1alpha1ToolCategoryRef item){
            return new ToolCategoryNestedImpl(-1, item);
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> setNewToolCategoryLike(int index,V1alpha1ToolCategoryRef item){
            return new ToolCategoryNestedImpl(index, item);
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> editToolCategory(int index){
            if (toolCategory.size() <= index) throw new RuntimeException("Can't edit toolCategory. Index exceeds size.");
            return setNewToolCategoryLike(index, buildToolCategory(index));
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> editFirstToolCategory(){
            if (toolCategory.size() == 0) throw new RuntimeException("Can't edit first toolCategory. The list is empty.");
            return setNewToolCategoryLike(0, buildToolCategory(0));
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> editLastToolCategory(){
            int index = toolCategory.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last toolCategory. The list is empty.");
            return setNewToolCategoryLike(index, buildToolCategory(index));
    }

    public V1alpha1ToolTypeSpecFluent.ToolCategoryNested<A> editMatchingToolCategory(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ToolCategoryRefBuilder> predicate){
            int index = -1;
            for (int i=0;i<toolCategory.size();i++) { 
            if (predicate.apply(toolCategory.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching toolCategory. No match found.");
            return setNewToolCategoryLike(index, buildToolCategory(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolTypeSpecFluentImpl that = (V1alpha1ToolTypeSpecFluentImpl) o;
            if (apiPath != null ? !apiPath.equals(that.apiPath) :that.apiPath != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
            if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
            if (enterprise != null ? !enterprise.equals(that.enterprise) :that.enterprise != null) return false;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (html != null ? !html.equals(that.html) :that.html != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (_public != null ? !_public.equals(that._public) :that._public != null) return false;
            if (recommendedVersion != null ? !recommendedVersion.equals(that.recommendedVersion) :that.recommendedVersion != null) return false;
            if (roleSyncEnabled != null ? !roleSyncEnabled.equals(that.roleSyncEnabled) :that.roleSyncEnabled != null) return false;
            if (supportedSecretTypes != null ? !supportedSecretTypes.equals(that.supportedSecretTypes) :that.supportedSecretTypes != null) return false;
            if (toolCategory != null ? !toolCategory.equals(that.toolCategory) :that.toolCategory != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class DescriptionNestedImpl<N> extends V1alpha1ToolTypeSpecDisplayNameFluentImpl<V1alpha1ToolTypeSpecFluent.DescriptionNested<N>> implements V1alpha1ToolTypeSpecFluent.DescriptionNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ToolTypeSpecDisplayNameBuilder builder;
    
            DescriptionNestedImpl(V1alpha1ToolTypeSpecDisplayName item){
                    this.builder = new V1alpha1ToolTypeSpecDisplayNameBuilder(this, item);
            }
            DescriptionNestedImpl(){
                    this.builder = new V1alpha1ToolTypeSpecDisplayNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ToolTypeSpecFluentImpl.this.withDescription(builder.build());
    }
    public N endDescription(){
            return and();
    }

}
    public class DisplayNameNestedImpl<N> extends V1alpha1ToolTypeSpecDisplayNameFluentImpl<V1alpha1ToolTypeSpecFluent.DisplayNameNested<N>> implements V1alpha1ToolTypeSpecFluent.DisplayNameNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ToolTypeSpecDisplayNameBuilder builder;
    
            DisplayNameNestedImpl(V1alpha1ToolTypeSpecDisplayName item){
                    this.builder = new V1alpha1ToolTypeSpecDisplayNameBuilder(this, item);
            }
            DisplayNameNestedImpl(){
                    this.builder = new V1alpha1ToolTypeSpecDisplayNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ToolTypeSpecFluentImpl.this.withDisplayName(builder.build());
    }
    public N endDisplayName(){
            return and();
    }

}
    public class SupportedSecretTypesNestedImpl<N> extends V1alpha1ToolTypeSpecSupportedSecretTypesFluentImpl<V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<N>> implements V1alpha1ToolTypeSpecFluent.SupportedSecretTypesNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ToolTypeSpecSupportedSecretTypesBuilder builder;
        private final int index;
    
            SupportedSecretTypesNestedImpl(int index,V1alpha1ToolTypeSpecSupportedSecretTypes item){
                    this.index = index;
                    this.builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(this, item);
            }
            SupportedSecretTypesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ToolTypeSpecSupportedSecretTypesBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ToolTypeSpecFluentImpl.this.setToSupportedSecretTypes(index, builder.build());
    }
    public N endSupportedSecretType(){
            return and();
    }

}
    public class ToolCategoryNestedImpl<N> extends V1alpha1ToolCategoryRefFluentImpl<V1alpha1ToolTypeSpecFluent.ToolCategoryNested<N>> implements V1alpha1ToolTypeSpecFluent.ToolCategoryNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ToolCategoryRefBuilder builder;
        private final int index;
    
            ToolCategoryNestedImpl(int index,V1alpha1ToolCategoryRef item){
                    this.index = index;
                    this.builder = new V1alpha1ToolCategoryRefBuilder(this, item);
            }
            ToolCategoryNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ToolCategoryRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ToolTypeSpecFluentImpl.this.setToToolCategory(index, builder.build());
    }
    public N endToolCategory(){
            return and();
    }

}


}
