package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RelationWhenItemBuilder extends V1alpha1RelationWhenItemFluentImpl<V1alpha1RelationWhenItemBuilder> implements VisitableBuilder<V1alpha1RelationWhenItem,V1alpha1RelationWhenItemBuilder>{

    V1alpha1RelationWhenItemFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1RelationWhenItemBuilder(){
            this(true);
    }
    public V1alpha1RelationWhenItemBuilder(Boolean validationEnabled){
            this(new V1alpha1RelationWhenItem(), validationEnabled);
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItemFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItemFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1RelationWhenItem(), validationEnabled);
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItemFluent<?> fluent,V1alpha1RelationWhenItem instance){
            this(fluent, instance, true);
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItemFluent<?> fluent,V1alpha1RelationWhenItem instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withValue(instance.isValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItem instance){
            this(instance,true);
    }
    public V1alpha1RelationWhenItemBuilder(V1alpha1RelationWhenItem instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withValue(instance.isValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1RelationWhenItem build(){
            V1alpha1RelationWhenItem buildable = new V1alpha1RelationWhenItem();
            buildable.setName(fluent.getName());
            buildable.setValue(fluent.isValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RelationWhenItemBuilder that = (V1alpha1RelationWhenItemBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
