package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl<A extends V1alpha1PipelineTemplateTaskInstanceSpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent<A>{

    private V1alpha1JenkinsAgentBuilder agent;
    private V1alpha1PipelineTaskApproveBuilder approve;
    private List<V1alpha1PipelineTemplateArgumentBuilder> arguments;
    private String body;
    private String engine;
    private List<V1alpha1PipelineEnvironmentBuilder> environments;
    private List<V1alpha1GlobalParameterBuilder> exports;
    private V1alpha1PipelineTaskOptionBuilder options;
    private List<V1alpha1PipelineTaskArgumentActionBuilder> relation;
    private String type;

    public V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl(){
    }
    public V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl(V1alpha1PipelineTemplateTaskInstanceSpec instance){
            this.withAgent(instance.getAgent());

            this.withApprove(instance.getApprove());

            this.withArguments(instance.getArguments());

            this.withBody(instance.getBody());

            this.withEngine(instance.getEngine());

            this.withEnvironments(instance.getEnvironments());

            this.withExports(instance.getExports());

            this.withOptions(instance.getOptions());

            this.withRelation(instance.getRelation());

            this.withType(instance.getType());

    }

    
/**
 * This method has been deprecated, please use method buildAgent instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1JenkinsAgent getAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public V1alpha1JenkinsAgent buildAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public A withAgent(V1alpha1JenkinsAgent agent){
            _visitables.get("agent").remove(this.agent);
            if (agent!=null){ this.agent= new V1alpha1JenkinsAgentBuilder(agent); _visitables.get("agent").add(this.agent);} return (A) this;
    }

    public Boolean hasAgent(){
            return this.agent != null;
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<A> withNewAgent(){
            return new AgentNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<A> withNewAgentLike(V1alpha1JenkinsAgent item){
            return new AgentNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<A> editAgent(){
            return withNewAgentLike(getAgent());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<A> editOrNewAgent(){
            return withNewAgentLike(getAgent() != null ? getAgent(): new V1alpha1JenkinsAgentBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<A> editOrNewAgentLike(V1alpha1JenkinsAgent item){
            return withNewAgentLike(getAgent() != null ? getAgent(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApprove instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTaskApprove getApprove(){
            return this.approve!=null?this.approve.build():null;
    }

    public V1alpha1PipelineTaskApprove buildApprove(){
            return this.approve!=null?this.approve.build():null;
    }

    public A withApprove(V1alpha1PipelineTaskApprove approve){
            _visitables.get("approve").remove(this.approve);
            if (approve!=null){ this.approve= new V1alpha1PipelineTaskApproveBuilder(approve); _visitables.get("approve").add(this.approve);} return (A) this;
    }

    public Boolean hasApprove(){
            return this.approve != null;
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<A> withNewApprove(){
            return new ApproveNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<A> withNewApproveLike(V1alpha1PipelineTaskApprove item){
            return new ApproveNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<A> editApprove(){
            return withNewApproveLike(getApprove());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<A> editOrNewApprove(){
            return withNewApproveLike(getApprove() != null ? getApprove(): new V1alpha1PipelineTaskApproveBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<A> editOrNewApproveLike(V1alpha1PipelineTaskApprove item){
            return withNewApproveLike(getApprove() != null ? getApprove(): item);
    }

    public A addToArguments(int index,V1alpha1PipelineTemplateArgument item){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentBuilder>();}
            V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);_visitables.get("arguments").add(index >= 0 ? index : _visitables.get("arguments").size(), builder);this.arguments.add(index >= 0 ? index : arguments.size(), builder); return (A)this;
    }

    public A setToArguments(int index,V1alpha1PipelineTemplateArgument item){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentBuilder>();}
            V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);
            if (index < 0 || index >= _visitables.get("arguments").size()) { _visitables.get("arguments").add(builder); } else { _visitables.get("arguments").set(index, builder);}
            if (index < 0 || index >= arguments.size()) { arguments.add(builder); } else { arguments.set(index, builder);}
             return (A)this;
    }

    public A addToArguments(V1alpha1PipelineTemplateArgument... items){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentBuilder>();}
            for (V1alpha1PipelineTemplateArgument item : items) {V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);_visitables.get("arguments").add(builder);this.arguments.add(builder);} return (A)this;
    }

    public A addAllToArguments(Collection<V1alpha1PipelineTemplateArgument> items){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentBuilder>();}
            for (V1alpha1PipelineTemplateArgument item : items) {V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);_visitables.get("arguments").add(builder);this.arguments.add(builder);} return (A)this;
    }

    public A removeFromArguments(V1alpha1PipelineTemplateArgument... items){
            for (V1alpha1PipelineTemplateArgument item : items) {V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);_visitables.get("arguments").remove(builder);if (this.arguments != null) {this.arguments.remove(builder);}} return (A)this;
    }

    public A removeAllFromArguments(Collection<V1alpha1PipelineTemplateArgument> items){
            for (V1alpha1PipelineTemplateArgument item : items) {V1alpha1PipelineTemplateArgumentBuilder builder = new V1alpha1PipelineTemplateArgumentBuilder(item);_visitables.get("arguments").remove(builder);if (this.arguments != null) {this.arguments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildArguments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTemplateArgument> getArguments(){
            return build(arguments);
    }

    public List<V1alpha1PipelineTemplateArgument> buildArguments(){
            return build(arguments);
    }

    public V1alpha1PipelineTemplateArgument buildArgument(int index){
            return this.arguments.get(index).build();
    }

    public V1alpha1PipelineTemplateArgument buildFirstArgument(){
            return this.arguments.get(0).build();
    }

    public V1alpha1PipelineTemplateArgument buildLastArgument(){
            return this.arguments.get(arguments.size() - 1).build();
    }

    public V1alpha1PipelineTemplateArgument buildMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentBuilder> predicate){
            for (V1alpha1PipelineTemplateArgumentBuilder item: arguments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentBuilder> predicate){
            for (V1alpha1PipelineTemplateArgumentBuilder item: arguments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withArguments(List<V1alpha1PipelineTemplateArgument> arguments){
            if (this.arguments != null) { _visitables.get("arguments").removeAll(this.arguments);}
            if (arguments != null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentBuilder>(); for (V1alpha1PipelineTemplateArgument item : arguments){this.addToArguments(item);}} else { this.arguments = null;} return (A) this;
    }

    public A withArguments(V1alpha1PipelineTemplateArgument... arguments){
            if (this.arguments != null) {this.arguments.clear();}
            if (arguments != null) {for (V1alpha1PipelineTemplateArgument item :arguments){ this.addToArguments(item);}} return (A) this;
    }

    public Boolean hasArguments(){
            return arguments != null && !arguments.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> addNewArgument(){
            return new ArgumentsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> addNewArgumentLike(V1alpha1PipelineTemplateArgument item){
            return new ArgumentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> setNewArgumentLike(int index,V1alpha1PipelineTemplateArgument item){
            return new ArgumentsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> editArgument(int index){
            if (arguments.size() <= index) throw new RuntimeException("Can't edit arguments. Index exceeds size.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> editFirstArgument(){
            if (arguments.size() == 0) throw new RuntimeException("Can't edit first arguments. The list is empty.");
            return setNewArgumentLike(0, buildArgument(0));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> editLastArgument(){
            int index = arguments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last arguments. The list is empty.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<A> editMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentBuilder> predicate){
            int index = -1;
            for (int i=0;i<arguments.size();i++) { 
            if (predicate.apply(arguments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching arguments. No match found.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public String getBody(){
            return this.body;
    }

    public A withBody(String body){
            this.body=body; return (A) this;
    }

    public Boolean hasBody(){
            return this.body != null;
    }

    public A withNewBody(String arg1){
            return (A)withBody(new String(arg1));
    }

    public A withNewBody(StringBuilder arg1){
            return (A)withBody(new String(arg1));
    }

    public A withNewBody(StringBuffer arg1){
            return (A)withBody(new String(arg1));
    }

    public String getEngine(){
            return this.engine;
    }

    public A withEngine(String engine){
            this.engine=engine; return (A) this;
    }

    public Boolean hasEngine(){
            return this.engine != null;
    }

    public A withNewEngine(String arg1){
            return (A)withEngine(new String(arg1));
    }

    public A withNewEngine(StringBuilder arg1){
            return (A)withEngine(new String(arg1));
    }

    public A withNewEngine(StringBuffer arg1){
            return (A)withEngine(new String(arg1));
    }

    public A addToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(index >= 0 ? index : _visitables.get("environments").size(), builder);this.environments.add(index >= 0 ? index : environments.size(), builder); return (A)this;
    }

    public A setToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);
            if (index < 0 || index >= _visitables.get("environments").size()) { _visitables.get("environments").add(builder); } else { _visitables.get("environments").set(index, builder);}
            if (index < 0 || index >= environments.size()) { environments.add(builder); } else { environments.set(index, builder);}
             return (A)this;
    }

    public A addToEnvironments(V1alpha1PipelineEnvironment... items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A addAllToEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A removeFromEnvironments(V1alpha1PipelineEnvironment... items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvironments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineEnvironment> getEnvironments(){
            return build(environments);
    }

    public List<V1alpha1PipelineEnvironment> buildEnvironments(){
            return build(environments);
    }

    public V1alpha1PipelineEnvironment buildEnvironment(int index){
            return this.environments.get(index).build();
    }

    public V1alpha1PipelineEnvironment buildFirstEnvironment(){
            return this.environments.get(0).build();
    }

    public V1alpha1PipelineEnvironment buildLastEnvironment(){
            return this.environments.get(environments.size() - 1).build();
    }

    public V1alpha1PipelineEnvironment buildMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withEnvironments(List<V1alpha1PipelineEnvironment> environments){
            if (this.environments != null) { _visitables.get("environments").removeAll(this.environments);}
            if (environments != null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>(); for (V1alpha1PipelineEnvironment item : environments){this.addToEnvironments(item);}} else { this.environments = null;} return (A) this;
    }

    public A withEnvironments(V1alpha1PipelineEnvironment... environments){
            if (this.environments != null) {this.environments.clear();}
            if (environments != null) {for (V1alpha1PipelineEnvironment item :environments){ this.addToEnvironments(item);}} return (A) this;
    }

    public Boolean hasEnvironments(){
            return environments != null && !environments.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> addNewEnvironment(){
            return new EnvironmentsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> addNewEnvironmentLike(V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> setNewEnvironmentLike(int index,V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> editEnvironment(int index){
            if (environments.size() <= index) throw new RuntimeException("Can't edit environments. Index exceeds size.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> editFirstEnvironment(){
            if (environments.size() == 0) throw new RuntimeException("Can't edit first environments. The list is empty.");
            return setNewEnvironmentLike(0, buildEnvironment(0));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> editLastEnvironment(){
            int index = environments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last environments. The list is empty.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<A> editMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            int index = -1;
            for (int i=0;i<environments.size();i++) { 
            if (predicate.apply(environments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching environments. No match found.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public A addToExports(int index,V1alpha1GlobalParameter item){
            if (this.exports == null) {this.exports = new ArrayList<V1alpha1GlobalParameterBuilder>();}
            V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);_visitables.get("exports").add(index >= 0 ? index : _visitables.get("exports").size(), builder);this.exports.add(index >= 0 ? index : exports.size(), builder); return (A)this;
    }

    public A setToExports(int index,V1alpha1GlobalParameter item){
            if (this.exports == null) {this.exports = new ArrayList<V1alpha1GlobalParameterBuilder>();}
            V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("exports").size()) { _visitables.get("exports").add(builder); } else { _visitables.get("exports").set(index, builder);}
            if (index < 0 || index >= exports.size()) { exports.add(builder); } else { exports.set(index, builder);}
             return (A)this;
    }

    public A addToExports(V1alpha1GlobalParameter... items){
            if (this.exports == null) {this.exports = new ArrayList<V1alpha1GlobalParameterBuilder>();}
            for (V1alpha1GlobalParameter item : items) {V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);_visitables.get("exports").add(builder);this.exports.add(builder);} return (A)this;
    }

    public A addAllToExports(Collection<V1alpha1GlobalParameter> items){
            if (this.exports == null) {this.exports = new ArrayList<V1alpha1GlobalParameterBuilder>();}
            for (V1alpha1GlobalParameter item : items) {V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);_visitables.get("exports").add(builder);this.exports.add(builder);} return (A)this;
    }

    public A removeFromExports(V1alpha1GlobalParameter... items){
            for (V1alpha1GlobalParameter item : items) {V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);_visitables.get("exports").remove(builder);if (this.exports != null) {this.exports.remove(builder);}} return (A)this;
    }

    public A removeAllFromExports(Collection<V1alpha1GlobalParameter> items){
            for (V1alpha1GlobalParameter item : items) {V1alpha1GlobalParameterBuilder builder = new V1alpha1GlobalParameterBuilder(item);_visitables.get("exports").remove(builder);if (this.exports != null) {this.exports.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildExports instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1GlobalParameter> getExports(){
            return build(exports);
    }

    public List<V1alpha1GlobalParameter> buildExports(){
            return build(exports);
    }

    public V1alpha1GlobalParameter buildExport(int index){
            return this.exports.get(index).build();
    }

    public V1alpha1GlobalParameter buildFirstExport(){
            return this.exports.get(0).build();
    }

    public V1alpha1GlobalParameter buildLastExport(){
            return this.exports.get(exports.size() - 1).build();
    }

    public V1alpha1GlobalParameter buildMatchingExport(io.alauda.devops.java.client.fluent.Predicate<V1alpha1GlobalParameterBuilder> predicate){
            for (V1alpha1GlobalParameterBuilder item: exports) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingExport(io.alauda.devops.java.client.fluent.Predicate<V1alpha1GlobalParameterBuilder> predicate){
            for (V1alpha1GlobalParameterBuilder item: exports) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withExports(List<V1alpha1GlobalParameter> exports){
            if (this.exports != null) { _visitables.get("exports").removeAll(this.exports);}
            if (exports != null) {this.exports = new ArrayList<V1alpha1GlobalParameterBuilder>(); for (V1alpha1GlobalParameter item : exports){this.addToExports(item);}} else { this.exports = null;} return (A) this;
    }

    public A withExports(V1alpha1GlobalParameter... exports){
            if (this.exports != null) {this.exports.clear();}
            if (exports != null) {for (V1alpha1GlobalParameter item :exports){ this.addToExports(item);}} return (A) this;
    }

    public Boolean hasExports(){
            return exports != null && !exports.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> addNewExport(){
            return new ExportsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> addNewExportLike(V1alpha1GlobalParameter item){
            return new ExportsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> setNewExportLike(int index,V1alpha1GlobalParameter item){
            return new ExportsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> editExport(int index){
            if (exports.size() <= index) throw new RuntimeException("Can't edit exports. Index exceeds size.");
            return setNewExportLike(index, buildExport(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> editFirstExport(){
            if (exports.size() == 0) throw new RuntimeException("Can't edit first exports. The list is empty.");
            return setNewExportLike(0, buildExport(0));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> editLastExport(){
            int index = exports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last exports. The list is empty.");
            return setNewExportLike(index, buildExport(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<A> editMatchingExport(io.alauda.devops.java.client.fluent.Predicate<V1alpha1GlobalParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<exports.size();i++) { 
            if (predicate.apply(exports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching exports. No match found.");
            return setNewExportLike(index, buildExport(index));
    }

    
/**
 * This method has been deprecated, please use method buildOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTaskOption getOptions(){
            return this.options!=null?this.options.build():null;
    }

    public V1alpha1PipelineTaskOption buildOptions(){
            return this.options!=null?this.options.build():null;
    }

    public A withOptions(V1alpha1PipelineTaskOption options){
            _visitables.get("options").remove(this.options);
            if (options!=null){ this.options= new V1alpha1PipelineTaskOptionBuilder(options); _visitables.get("options").add(this.options);} return (A) this;
    }

    public Boolean hasOptions(){
            return this.options != null;
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<A> withNewOptions(){
            return new OptionsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<A> withNewOptionsLike(V1alpha1PipelineTaskOption item){
            return new OptionsNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<A> editOptions(){
            return withNewOptionsLike(getOptions());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<A> editOrNewOptions(){
            return withNewOptionsLike(getOptions() != null ? getOptions(): new V1alpha1PipelineTaskOptionBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<A> editOrNewOptionsLike(V1alpha1PipelineTaskOption item){
            return withNewOptionsLike(getOptions() != null ? getOptions(): item);
    }

    public A addToRelation(int index,V1alpha1PipelineTaskArgumentAction item){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(index >= 0 ? index : _visitables.get("relation").size(), builder);this.relation.add(index >= 0 ? index : relation.size(), builder); return (A)this;
    }

    public A setToRelation(int index,V1alpha1PipelineTaskArgumentAction item){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);
            if (index < 0 || index >= _visitables.get("relation").size()) { _visitables.get("relation").add(builder); } else { _visitables.get("relation").set(index, builder);}
            if (index < 0 || index >= relation.size()) { relation.add(builder); } else { relation.set(index, builder);}
             return (A)this;
    }

    public A addToRelation(V1alpha1PipelineTaskArgumentAction... items){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(builder);this.relation.add(builder);} return (A)this;
    }

    public A addAllToRelation(Collection<V1alpha1PipelineTaskArgumentAction> items){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(builder);this.relation.add(builder);} return (A)this;
    }

    public A removeFromRelation(V1alpha1PipelineTaskArgumentAction... items){
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").remove(builder);if (this.relation != null) {this.relation.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelation(Collection<V1alpha1PipelineTaskArgumentAction> items){
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").remove(builder);if (this.relation != null) {this.relation.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRelation instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTaskArgumentAction> getRelation(){
            return build(relation);
    }

    public List<V1alpha1PipelineTaskArgumentAction> buildRelation(){
            return build(relation);
    }

    public V1alpha1PipelineTaskArgumentAction buildRelation(int index){
            return this.relation.get(index).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildFirstRelation(){
            return this.relation.get(0).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildLastRelation(){
            return this.relation.get(relation.size() - 1).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            for (V1alpha1PipelineTaskArgumentActionBuilder item: relation) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            for (V1alpha1PipelineTaskArgumentActionBuilder item: relation) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRelation(List<V1alpha1PipelineTaskArgumentAction> relation){
            if (this.relation != null) { _visitables.get("relation").removeAll(this.relation);}
            if (relation != null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>(); for (V1alpha1PipelineTaskArgumentAction item : relation){this.addToRelation(item);}} else { this.relation = null;} return (A) this;
    }

    public A withRelation(V1alpha1PipelineTaskArgumentAction... relation){
            if (this.relation != null) {this.relation.clear();}
            if (relation != null) {for (V1alpha1PipelineTaskArgumentAction item :relation){ this.addToRelation(item);}} return (A) this;
    }

    public Boolean hasRelation(){
            return relation != null && !relation.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> addNewRelation(){
            return new RelationNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> addNewRelationLike(V1alpha1PipelineTaskArgumentAction item){
            return new RelationNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> setNewRelationLike(int index,V1alpha1PipelineTaskArgumentAction item){
            return new RelationNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> editRelation(int index){
            if (relation.size() <= index) throw new RuntimeException("Can't edit relation. Index exceeds size.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> editFirstRelation(){
            if (relation.size() == 0) throw new RuntimeException("Can't edit first relation. The list is empty.");
            return setNewRelationLike(0, buildRelation(0));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> editLastRelation(){
            int index = relation.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last relation. The list is empty.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<A> editMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            int index = -1;
            for (int i=0;i<relation.size();i++) { 
            if (predicate.apply(relation.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching relation. No match found.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl that = (V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl) o;
            if (agent != null ? !agent.equals(that.agent) :that.agent != null) return false;
            if (approve != null ? !approve.equals(that.approve) :that.approve != null) return false;
            if (arguments != null ? !arguments.equals(that.arguments) :that.arguments != null) return false;
            if (body != null ? !body.equals(that.body) :that.body != null) return false;
            if (engine != null ? !engine.equals(that.engine) :that.engine != null) return false;
            if (environments != null ? !environments.equals(that.environments) :that.environments != null) return false;
            if (exports != null ? !exports.equals(that.exports) :that.exports != null) return false;
            if (options != null ? !options.equals(that.options) :that.options != null) return false;
            if (relation != null ? !relation.equals(that.relation) :that.relation != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class AgentNestedImpl<N> extends V1alpha1JenkinsAgentFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.AgentNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsAgentBuilder builder;
    
            AgentNestedImpl(V1alpha1JenkinsAgent item){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this, item);
            }
            AgentNestedImpl(){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.withAgent(builder.build());
    }
    public N endAgent(){
            return and();
    }

}
    public class ApproveNestedImpl<N> extends V1alpha1PipelineTaskApproveFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.ApproveNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskApproveBuilder builder;
    
            ApproveNestedImpl(V1alpha1PipelineTaskApprove item){
                    this.builder = new V1alpha1PipelineTaskApproveBuilder(this, item);
            }
            ApproveNestedImpl(){
                    this.builder = new V1alpha1PipelineTaskApproveBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.withApprove(builder.build());
    }
    public N endApprove(){
            return and();
    }

}
    public class ArgumentsNestedImpl<N> extends V1alpha1PipelineTemplateArgumentFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.ArgumentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateArgumentBuilder builder;
        private final int index;
    
            ArgumentsNestedImpl(int index,V1alpha1PipelineTemplateArgument item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTemplateArgumentBuilder(this, item);
            }
            ArgumentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTemplateArgumentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.setToArguments(index, builder.build());
    }
    public N endArgument(){
            return and();
    }

}
    public class EnvironmentsNestedImpl<N> extends V1alpha1PipelineEnvironmentFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.EnvironmentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineEnvironmentBuilder builder;
        private final int index;
    
            EnvironmentsNestedImpl(int index,V1alpha1PipelineEnvironment item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this, item);
            }
            EnvironmentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.setToEnvironments(index, builder.build());
    }
    public N endEnvironment(){
            return and();
    }

}
    public class ExportsNestedImpl<N> extends V1alpha1GlobalParameterFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.ExportsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1GlobalParameterBuilder builder;
        private final int index;
    
            ExportsNestedImpl(int index,V1alpha1GlobalParameter item){
                    this.index = index;
                    this.builder = new V1alpha1GlobalParameterBuilder(this, item);
            }
            ExportsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1GlobalParameterBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.setToExports(index, builder.build());
    }
    public N endExport(){
            return and();
    }

}
    public class OptionsNestedImpl<N> extends V1alpha1PipelineTaskOptionFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.OptionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskOptionBuilder builder;
    
            OptionsNestedImpl(V1alpha1PipelineTaskOption item){
                    this.builder = new V1alpha1PipelineTaskOptionBuilder(this, item);
            }
            OptionsNestedImpl(){
                    this.builder = new V1alpha1PipelineTaskOptionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.withOptions(builder.build());
    }
    public N endOptions(){
            return and();
    }

}
    public class RelationNestedImpl<N> extends V1alpha1PipelineTaskArgumentActionFluentImpl<V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<N>> implements V1alpha1PipelineTemplateTaskInstanceSpecFluent.RelationNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskArgumentActionBuilder builder;
        private final int index;
    
            RelationNestedImpl(int index,V1alpha1PipelineTaskArgumentAction item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTaskArgumentActionBuilder(this, item);
            }
            RelationNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTaskArgumentActionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl.this.setToRelation(index, builder.build());
    }
    public N endRelation(){
            return and();
    }

}


}
