package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSpecBuilder extends V1alpha1PipelineTemplateSpecFluentImpl<V1alpha1PipelineTemplateSpecBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateSpec,V1alpha1PipelineTemplateSpecBuilder>{

    V1alpha1PipelineTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpecFluent<?> fluent,V1alpha1PipelineTemplateSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpecFluent<?> fluent,V1alpha1PipelineTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAgent(instance.getAgent());

            fluent.withArguments(instance.getArguments());

            fluent.withEngine(instance.getEngine());

            fluent.withEnvironments(instance.getEnvironments());

            fluent.withOptions(instance.getOptions());

            fluent.withParameters(instance.getParameters());

            fluent.withPost(instance.getPost());

            fluent.withStages(instance.getStages());

            fluent.withSupportedTriggers(instance.getSupportedTriggers());

            fluent.withTriggers(instance.getTriggers());

            fluent.withValues(instance.getValues());

            fluent.withWithSCM(instance.isWithSCM());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateSpecBuilder(V1alpha1PipelineTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAgent(instance.getAgent());

            this.withArguments(instance.getArguments());

            this.withEngine(instance.getEngine());

            this.withEnvironments(instance.getEnvironments());

            this.withOptions(instance.getOptions());

            this.withParameters(instance.getParameters());

            this.withPost(instance.getPost());

            this.withStages(instance.getStages());

            this.withSupportedTriggers(instance.getSupportedTriggers());

            this.withTriggers(instance.getTriggers());

            this.withValues(instance.getValues());

            this.withWithSCM(instance.isWithSCM());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateSpec build(){
            V1alpha1PipelineTemplateSpec buildable = new V1alpha1PipelineTemplateSpec();
            buildable.setAgent(fluent.getAgent());
            buildable.setArguments(fluent.getArguments());
            buildable.setEngine(fluent.getEngine());
            buildable.setEnvironments(fluent.getEnvironments());
            buildable.setOptions(fluent.getOptions());
            buildable.setParameters(fluent.getParameters());
            buildable.setPost(fluent.getPost());
            buildable.setStages(fluent.getStages());
            buildable.setSupportedTriggers(fluent.getSupportedTriggers());
            buildable.setTriggers(fluent.getTriggers());
            buildable.setValues(fluent.getValues());
            buildable.setWithSCM(fluent.isWithSCM());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSpecBuilder that = (V1alpha1PipelineTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
