package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskTemplateBuilder extends V1alpha1PipelineTaskTemplateFluentImpl<V1alpha1PipelineTaskTemplateBuilder> implements VisitableBuilder<V1alpha1PipelineTaskTemplate,V1alpha1PipelineTaskTemplateBuilder>{

    V1alpha1PipelineTaskTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskTemplateBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskTemplate(), validationEnabled);
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskTemplate(), validationEnabled);
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplateFluent<?> fluent,V1alpha1PipelineTaskTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplateFluent<?> fluent,V1alpha1PipelineTaskTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplate instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskTemplateBuilder(V1alpha1PipelineTaskTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskTemplate build(){
            V1alpha1PipelineTaskTemplate buildable = new V1alpha1PipelineTaskTemplate();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskTemplateBuilder that = (V1alpha1PipelineTaskTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
