package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigTemplateSpecBuilder extends V1alpha1PipelineConfigTemplateSpecFluentImpl<V1alpha1PipelineConfigTemplateSpecBuilder> implements VisitableBuilder<V1alpha1PipelineConfigTemplateSpec,V1alpha1PipelineConfigTemplateSpecBuilder>{

    V1alpha1PipelineConfigTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigTemplateSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpecFluent<?> fluent,V1alpha1PipelineConfigTemplateSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpecFluent<?> fluent,V1alpha1PipelineConfigTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAgent(instance.getAgent());

            fluent.withArguments(instance.getArguments());

            fluent.withDependencies(instance.getDependencies());

            fluent.withEngine(instance.getEngine());

            fluent.withEnvironments(instance.getEnvironments());

            fluent.withParameters(instance.getParameters());

            fluent.withStages(instance.getStages());

            fluent.withWithSCM(instance.isWithSCM());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigTemplateSpecBuilder(V1alpha1PipelineConfigTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAgent(instance.getAgent());

            this.withArguments(instance.getArguments());

            this.withDependencies(instance.getDependencies());

            this.withEngine(instance.getEngine());

            this.withEnvironments(instance.getEnvironments());

            this.withParameters(instance.getParameters());

            this.withStages(instance.getStages());

            this.withWithSCM(instance.isWithSCM());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigTemplateSpec build(){
            V1alpha1PipelineConfigTemplateSpec buildable = new V1alpha1PipelineConfigTemplateSpec();
            buildable.setAgent(fluent.getAgent());
            buildable.setArguments(fluent.getArguments());
            buildable.setDependencies(fluent.getDependencies());
            buildable.setEngine(fluent.getEngine());
            buildable.setEnvironments(fluent.getEnvironments());
            buildable.setParameters(fluent.getParameters());
            buildable.setStages(fluent.getStages());
            buildable.setWithSCM(fluent.isWithSCM());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigTemplateSpecBuilder that = (V1alpha1PipelineConfigTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
