package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineBlueOceanRefBuilder extends V1alpha1PipelineBlueOceanRefFluentImpl<V1alpha1PipelineBlueOceanRefBuilder> implements VisitableBuilder<V1alpha1PipelineBlueOceanRef,V1alpha1PipelineBlueOceanRefBuilder>{

    V1alpha1PipelineBlueOceanRefFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineBlueOceanRefBuilder(){
            this(true);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineBlueOceanRef(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRefFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineBlueOceanRef(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRefFluent<?> fluent,V1alpha1PipelineBlueOceanRef instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRefFluent<?> fluent,V1alpha1PipelineBlueOceanRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDescription(instance.getDescription());

            fluent.withHref(instance.getHref());

            fluent.withId(instance.getId());

            fluent.withName(instance.getName());

            fluent.withType(instance.getType());

            fluent.withUrlName(instance.getUrlName());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRef instance){
            this(instance,true);
    }
    public V1alpha1PipelineBlueOceanRefBuilder(V1alpha1PipelineBlueOceanRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDescription(instance.getDescription());

            this.withHref(instance.getHref());

            this.withId(instance.getId());

            this.withName(instance.getName());

            this.withType(instance.getType());

            this.withUrlName(instance.getUrlName());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineBlueOceanRef build(){
            V1alpha1PipelineBlueOceanRef buildable = new V1alpha1PipelineBlueOceanRef();
            buildable.setDescription(fluent.getDescription());
            buildable.setHref(fluent.getHref());
            buildable.setId(fluent.getId());
            buildable.setName(fluent.getName());
            buildable.setType(fluent.getType());
            buildable.setUrlName(fluent.getUrlName());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineBlueOceanRefBuilder that = (V1alpha1PipelineBlueOceanRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
