package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1IssueKeyOptionsBuilder extends V1alpha1IssueKeyOptionsFluentImpl<V1alpha1IssueKeyOptionsBuilder> implements VisitableBuilder<V1alpha1IssueKeyOptions,V1alpha1IssueKeyOptionsBuilder>{

    V1alpha1IssueKeyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1IssueKeyOptionsBuilder(){
            this(true);
    }
    public V1alpha1IssueKeyOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1IssueKeyOptions(), validationEnabled);
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1IssueKeyOptions(), validationEnabled);
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptionsFluent<?> fluent,V1alpha1IssueKeyOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptionsFluent<?> fluent,V1alpha1IssueKeyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKey(instance.getKey());

            fluent.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptions instance){
            this(instance,true);
    }
    public V1alpha1IssueKeyOptionsBuilder(V1alpha1IssueKeyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKey(instance.getKey());

            this.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1IssueKeyOptions build(){
            V1alpha1IssueKeyOptions buildable = new V1alpha1IssueKeyOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKey(fluent.getKey());
            buildable.setKind(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1IssueKeyOptionsBuilder that = (V1alpha1IssueKeyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
