package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageTagOptionsBuilder extends V1alpha1ImageTagOptionsFluentImpl<V1alpha1ImageTagOptionsBuilder> implements VisitableBuilder<V1alpha1ImageTagOptions,V1alpha1ImageTagOptionsBuilder>{

    V1alpha1ImageTagOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageTagOptionsBuilder(){
            this(true);
    }
    public V1alpha1ImageTagOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageTagOptions(), validationEnabled);
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageTagOptions(), validationEnabled);
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptionsFluent<?> fluent,V1alpha1ImageTagOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptionsFluent<?> fluent,V1alpha1ImageTagOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withSortBy(instance.getSortBy());

            fluent.withSortMode(instance.getSortMode());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptions instance){
            this(instance,true);
    }
    public V1alpha1ImageTagOptionsBuilder(V1alpha1ImageTagOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withSortBy(instance.getSortBy());

            this.withSortMode(instance.getSortMode());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageTagOptions build(){
            V1alpha1ImageTagOptions buildable = new V1alpha1ImageTagOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setSortBy(fluent.getSortBy());
            buildable.setSortMode(fluent.getSortMode());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageTagOptionsBuilder that = (V1alpha1ImageTagOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
