package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CorrespondCodeQualityProjectsOptionsFluentImpl<A extends V1alpha1CorrespondCodeQualityProjectsOptionsFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CorrespondCodeQualityProjectsOptionsFluent<A>{

    private String apiVersion;
    private String kind;
    private List<String> repositories;

    public V1alpha1CorrespondCodeQualityProjectsOptionsFluentImpl(){
    }
    public V1alpha1CorrespondCodeQualityProjectsOptionsFluentImpl(V1alpha1CorrespondCodeQualityProjectsOptions instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withRepositories(instance.getRepositories());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToRepositories(int index,String item){
            if (this.repositories == null) {this.repositories = new ArrayList<String>();}
            this.repositories.add(index, item);
            return (A)this;
    }

    public A setToRepositories(int index,String item){
            if (this.repositories == null) {this.repositories = new ArrayList<String>();}
            this.repositories.set(index, item); return (A)this;
    }

    public A addToRepositories(String... items){
            if (this.repositories == null) {this.repositories = new ArrayList<String>();}
            for (String item : items) {this.repositories.add(item);} return (A)this;
    }

    public A addAllToRepositories(Collection<String> items){
            if (this.repositories == null) {this.repositories = new ArrayList<String>();}
            for (String item : items) {this.repositories.add(item);} return (A)this;
    }

    public A removeFromRepositories(String... items){
            for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
    }

    public A removeAllFromRepositories(Collection<String> items){
            for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
    }

    public List<String> getRepositories(){
            return this.repositories;
    }

    public String getRepository(int index){
            return this.repositories.get(index);
    }

    public String getFirstRepository(){
            return this.repositories.get(0);
    }

    public String getLastRepository(){
            return this.repositories.get(repositories.size() - 1);
    }

    public String getMatchingRepository(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: repositories) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingRepository(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: repositories) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRepositories(List<String> repositories){
            if (this.repositories != null) { _visitables.get("repositories").removeAll(this.repositories);}
            if (repositories != null) {this.repositories = new ArrayList<String>(); for (String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
    }

    public A withRepositories(String... repositories){
            if (this.repositories != null) {this.repositories.clear();}
            if (repositories != null) {for (String item :repositories){ this.addToRepositories(item);}} return (A) this;
    }

    public Boolean hasRepositories(){
            return repositories != null && !repositories.isEmpty();
    }

    public A addNewRepository(String arg1){
            return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(StringBuilder arg1){
            return (A)addToRepositories(new String(arg1));
    }

    public A addNewRepository(StringBuffer arg1){
            return (A)addToRepositories(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CorrespondCodeQualityProjectsOptionsFluentImpl that = (V1alpha1CorrespondCodeQualityProjectsOptionsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
            return true;
    }




}
