package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityProjectOptionsBuilder extends V1alpha1CodeQualityProjectOptionsFluentImpl<V1alpha1CodeQualityProjectOptionsBuilder> implements VisitableBuilder<V1alpha1CodeQualityProjectOptions,V1alpha1CodeQualityProjectOptionsBuilder>{

    V1alpha1CodeQualityProjectOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityProjectOptionsBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityProjectOptions(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityProjectOptions(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptionsFluent<?> fluent,V1alpha1CodeQualityProjectOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptionsFluent<?> fluent,V1alpha1CodeQualityProjectOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withProjectKey(instance.getProjectKey());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptions instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityProjectOptionsBuilder(V1alpha1CodeQualityProjectOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withProjectKey(instance.getProjectKey());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityProjectOptions build(){
            V1alpha1CodeQualityProjectOptions buildable = new V1alpha1CodeQualityProjectOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setProjectKey(fluent.getProjectKey());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityProjectOptionsBuilder that = (V1alpha1CodeQualityProjectOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
