package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterPipelineTemplateFluentImpl<A extends V1alpha1ClusterPipelineTemplateFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ClusterPipelineTemplateFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMeta metadata;
    private V1alpha1PipelineTemplateSpecBuilder spec;
    private V1alpha1TemplateStatusBuilder status;

    public V1alpha1ClusterPipelineTemplateFluentImpl(){
    }
    public V1alpha1ClusterPipelineTemplateFluentImpl(V1alpha1ClusterPipelineTemplate instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTemplateSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1alpha1PipelineTemplateSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1alpha1PipelineTemplateSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1alpha1PipelineTemplateSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1alpha1ClusterPipelineTemplateFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1ClusterPipelineTemplateFluent.SpecNested<A> withNewSpecLike(V1alpha1PipelineTemplateSpec item){
            return new SpecNestedImpl(item);
    }

    public V1alpha1ClusterPipelineTemplateFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1alpha1ClusterPipelineTemplateFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1alpha1PipelineTemplateSpecBuilder().build());
    }

    public V1alpha1ClusterPipelineTemplateFluent.SpecNested<A> editOrNewSpecLike(V1alpha1PipelineTemplateSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1TemplateStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1alpha1TemplateStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1alpha1TemplateStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new V1alpha1TemplateStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1alpha1ClusterPipelineTemplateFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1alpha1ClusterPipelineTemplateFluent.StatusNested<A> withNewStatusLike(V1alpha1TemplateStatus item){
            return new StatusNestedImpl(item);
    }

    public V1alpha1ClusterPipelineTemplateFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1alpha1ClusterPipelineTemplateFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1alpha1TemplateStatusBuilder().build());
    }

    public V1alpha1ClusterPipelineTemplateFluent.StatusNested<A> editOrNewStatusLike(V1alpha1TemplateStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterPipelineTemplateFluentImpl that = (V1alpha1ClusterPipelineTemplateFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1PipelineTemplateSpecFluentImpl<V1alpha1ClusterPipelineTemplateFluent.SpecNested<N>> implements V1alpha1ClusterPipelineTemplateFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateSpecBuilder builder;
    
            SpecNestedImpl(V1alpha1PipelineTemplateSpec item){
                    this.builder = new V1alpha1PipelineTemplateSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1alpha1PipelineTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterPipelineTemplateFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1alpha1TemplateStatusFluentImpl<V1alpha1ClusterPipelineTemplateFluent.StatusNested<N>> implements V1alpha1ClusterPipelineTemplateFluent.StatusNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1TemplateStatusBuilder builder;
    
            StatusNestedImpl(V1alpha1TemplateStatus item){
                    this.builder = new V1alpha1TemplateStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1alpha1TemplateStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterPipelineTemplateFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
