package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistryManagerOptionsBuilder extends V1alpha1ArtifactRegistryManagerOptionsFluentImpl<V1alpha1ArtifactRegistryManagerOptionsBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistryManagerOptions,V1alpha1ArtifactRegistryManagerOptionsBuilder>{

    V1alpha1ArtifactRegistryManagerOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistryManagerOptionsBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistryManagerOptions(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistryManagerOptions(), validationEnabled);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptionsFluent<?> fluent,V1alpha1ArtifactRegistryManagerOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptionsFluent<?> fluent,V1alpha1ArtifactRegistryManagerOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptions instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistryManagerOptionsBuilder(V1alpha1ArtifactRegistryManagerOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistryManagerOptions build(){
            V1alpha1ArtifactRegistryManagerOptions buildable = new V1alpha1ArtifactRegistryManagerOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistryManagerOptionsBuilder that = (V1alpha1ArtifactRegistryManagerOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
