/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PipelineInputOptions options for pipeline input request")
public class V1alpha1PipelineInputOptions {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="approve")
    private Boolean approve = null;
    @SerializedName(value="inputID")
    private String inputID = null;
    @SerializedName(value="parameters")
    private List<V1alpha1PipelineParameter> parameters = null;
    @SerializedName(value="platformApprover")
    private String platformApprover = null;
    @SerializedName(value="stage")
    private Long stage = null;
    @SerializedName(value="step")
    private Long step = null;

    public V1alpha1PipelineInputOptions apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1PipelineInputOptions kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1PipelineInputOptions approve(Boolean approve) {
        this.approve = approve;
        return this;
    }

    @ApiModelProperty(required=true, value="Approve whether approve this")
    public Boolean isApprove() {
        return this.approve;
    }

    public void setApprove(Boolean approve) {
        this.approve = approve;
    }

    public V1alpha1PipelineInputOptions inputID(String inputID) {
        this.inputID = inputID;
        return this;
    }

    @ApiModelProperty(required=true, value="InputID is the id for input dsl step from Jenkinsfile")
    public String getInputID() {
        return this.inputID;
    }

    public void setInputID(String inputID) {
        this.inputID = inputID;
    }

    public V1alpha1PipelineInputOptions parameters(List<V1alpha1PipelineParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1alpha1PipelineInputOptions addParametersItem(V1alpha1PipelineParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<V1alpha1PipelineParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @ApiModelProperty(value="Parameters is the parameters of the pipeline input request")
    public List<V1alpha1PipelineParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<V1alpha1PipelineParameter> parameters) {
        this.parameters = parameters;
    }

    public V1alpha1PipelineInputOptions platformApprover(String platformApprover) {
        this.platformApprover = platformApprover;
        return this;
    }

    @ApiModelProperty(value="PlatformApprover for who approve or reject this")
    public String getPlatformApprover() {
        return this.platformApprover;
    }

    public void setPlatformApprover(String platformApprover) {
        this.platformApprover = platformApprover;
    }

    public V1alpha1PipelineInputOptions stage(Long stage) {
        this.stage = stage;
        return this;
    }

    @ApiModelProperty(required=true, value="Stage if given will limit the log to a specific stage")
    public Long getStage() {
        return this.stage;
    }

    public void setStage(Long stage) {
        this.stage = stage;
    }

    public V1alpha1PipelineInputOptions step(Long step) {
        this.step = step;
        return this;
    }

    @ApiModelProperty(required=true, value="Step if given will limit the log to a specific step")
    public Long getStep() {
        return this.step;
    }

    public void setStep(Long step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PipelineInputOptions v1alpha1PipelineInputOptions = (V1alpha1PipelineInputOptions)o;
        return Objects.equals(this.apiVersion, v1alpha1PipelineInputOptions.apiVersion) && Objects.equals(this.kind, v1alpha1PipelineInputOptions.kind) && Objects.equals(this.approve, v1alpha1PipelineInputOptions.approve) && Objects.equals(this.inputID, v1alpha1PipelineInputOptions.inputID) && Objects.equals(this.parameters, v1alpha1PipelineInputOptions.parameters) && Objects.equals(this.platformApprover, v1alpha1PipelineInputOptions.platformApprover) && Objects.equals(this.stage, v1alpha1PipelineInputOptions.stage) && Objects.equals(this.step, v1alpha1PipelineInputOptions.step);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.approve, this.inputID, this.parameters, this.platformApprover, this.stage, this.step);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PipelineInputOptions {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    approve: ").append(this.toIndentedString(this.approve)).append("\n");
        sb.append("    inputID: ").append(this.toIndentedString(this.inputID)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    platformApprover: ").append(this.toIndentedString(this.platformApprover)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString(this.stage)).append("\n");
        sb.append("    step: ").append(this.toIndentedString(this.step)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

