package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolTypeSpecBuilder extends V1alpha1ToolTypeSpecFluentImpl<V1alpha1ToolTypeSpecBuilder> implements VisitableBuilder<V1alpha1ToolTypeSpec,V1alpha1ToolTypeSpecBuilder>{

    V1alpha1ToolTypeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolTypeSpecBuilder(){
            this(true);
    }
    public V1alpha1ToolTypeSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolTypeSpec(), validationEnabled);
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolTypeSpec(), validationEnabled);
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpecFluent<?> fluent,V1alpha1ToolTypeSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpecFluent<?> fluent,V1alpha1ToolTypeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiPath(instance.getApiPath());

            fluent.withDisplayName(instance.getDisplayName());

            fluent.withEnabled(instance.isEnabled());

            fluent.withEnterprise(instance.isEnterprise());

            fluent.withHost(instance.getHost());

            fluent.withHtml(instance.getHtml());

            fluent.withKind(instance.getKind());

            fluent.withPublic(instance.isPublic());

            fluent.withRoleSyncEnabled(instance.isRoleSyncEnabled());

            fluent.withSupportedSecretTypes(instance.getSupportedSecretTypes());

            fluent.withToolCategory(instance.getToolCategory());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpec instance){
            this(instance,true);
    }
    public V1alpha1ToolTypeSpecBuilder(V1alpha1ToolTypeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiPath(instance.getApiPath());

            this.withDisplayName(instance.getDisplayName());

            this.withEnabled(instance.isEnabled());

            this.withEnterprise(instance.isEnterprise());

            this.withHost(instance.getHost());

            this.withHtml(instance.getHtml());

            this.withKind(instance.getKind());

            this.withPublic(instance.isPublic());

            this.withRoleSyncEnabled(instance.isRoleSyncEnabled());

            this.withSupportedSecretTypes(instance.getSupportedSecretTypes());

            this.withToolCategory(instance.getToolCategory());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolTypeSpec build(){
            V1alpha1ToolTypeSpec buildable = new V1alpha1ToolTypeSpec();
            buildable.setApiPath(fluent.getApiPath());
            buildable.setDisplayName(fluent.getDisplayName());
            buildable.setEnabled(fluent.isEnabled());
            buildable.setEnterprise(fluent.isEnterprise());
            buildable.setHost(fluent.getHost());
            buildable.setHtml(fluent.getHtml());
            buildable.setKind(fluent.getKind());
            buildable.setPublic(fluent.isPublic());
            buildable.setRoleSyncEnabled(fluent.isRoleSyncEnabled());
            buildable.setSupportedSecretTypes(fluent.getSupportedSecretTypes());
            buildable.setToolCategory(fluent.getToolCategory());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolTypeSpecBuilder that = (V1alpha1ToolTypeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
