package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolTypeListBuilder extends V1alpha1ToolTypeListFluentImpl<V1alpha1ToolTypeListBuilder> implements VisitableBuilder<V1alpha1ToolTypeList,V1alpha1ToolTypeListBuilder>{

    V1alpha1ToolTypeListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolTypeListBuilder(){
            this(true);
    }
    public V1alpha1ToolTypeListBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolTypeList(), validationEnabled);
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolTypeList(), validationEnabled);
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeListFluent<?> fluent,V1alpha1ToolTypeList instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeListFluent<?> fluent,V1alpha1ToolTypeList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeList instance){
            this(instance,true);
    }
    public V1alpha1ToolTypeListBuilder(V1alpha1ToolTypeList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolTypeList build(){
            V1alpha1ToolTypeList buildable = new V1alpha1ToolTypeList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolTypeListBuilder that = (V1alpha1ToolTypeListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
