package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolCategorySpecBuilder extends V1alpha1ToolCategorySpecFluentImpl<V1alpha1ToolCategorySpecBuilder> implements VisitableBuilder<V1alpha1ToolCategorySpec,V1alpha1ToolCategorySpecBuilder>{

    V1alpha1ToolCategorySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolCategorySpecBuilder(){
            this(true);
    }
    public V1alpha1ToolCategorySpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolCategorySpec(), validationEnabled);
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolCategorySpec(), validationEnabled);
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpecFluent<?> fluent,V1alpha1ToolCategorySpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpecFluent<?> fluent,V1alpha1ToolCategorySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDisplayName(instance.getDisplayName());

            fluent.withEnabled(instance.isEnabled());

            fluent.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpec instance){
            this(instance,true);
    }
    public V1alpha1ToolCategorySpecBuilder(V1alpha1ToolCategorySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDisplayName(instance.getDisplayName());

            this.withEnabled(instance.isEnabled());

            this.withKind(instance.getKind());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolCategorySpec build(){
            V1alpha1ToolCategorySpec buildable = new V1alpha1ToolCategorySpec();
            buildable.setDisplayName(fluent.getDisplayName());
            buildable.setEnabled(fluent.isEnabled());
            buildable.setKind(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolCategorySpecBuilder that = (V1alpha1ToolCategorySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
