package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSyncStatusBuilder extends V1alpha1PipelineTemplateSyncStatusFluentImpl<V1alpha1PipelineTemplateSyncStatusBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateSyncStatus,V1alpha1PipelineTemplateSyncStatusBuilder>{

    V1alpha1PipelineTemplateSyncStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateSyncStatusBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateSyncStatus(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateSyncStatus(), validationEnabled);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatusFluent<?> fluent,V1alpha1PipelineTemplateSyncStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatusFluent<?> fluent,V1alpha1PipelineTemplateSyncStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCommitID(instance.getCommitID());

            fluent.withConditions(instance.getConditions());

            fluent.withEndTime(instance.getEndTime());

            fluent.withError(instance.getError());

            fluent.withMessage(instance.getMessage());

            fluent.withPhase(instance.getPhase());

            fluent.withStartTime(instance.getStartTime());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatus instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateSyncStatusBuilder(V1alpha1PipelineTemplateSyncStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCommitID(instance.getCommitID());

            this.withConditions(instance.getConditions());

            this.withEndTime(instance.getEndTime());

            this.withError(instance.getError());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withStartTime(instance.getStartTime());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateSyncStatus build(){
            V1alpha1PipelineTemplateSyncStatus buildable = new V1alpha1PipelineTemplateSyncStatus();
            buildable.setCommitID(fluent.getCommitID());
            buildable.setConditions(fluent.getConditions());
            buildable.setEndTime(fluent.getEndTime());
            buildable.setError(fluent.getError());
            buildable.setMessage(fluent.getMessage());
            buildable.setPhase(fluent.getPhase());
            buildable.setStartTime(fluent.getStartTime());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSyncStatusBuilder that = (V1alpha1PipelineTemplateSyncStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
