package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskArgumentDisplayBuilder extends V1alpha1PipelineTaskArgumentDisplayFluentImpl<V1alpha1PipelineTaskArgumentDisplayBuilder> implements VisitableBuilder<V1alpha1PipelineTaskArgumentDisplay,V1alpha1PipelineTaskArgumentDisplayBuilder>{

    V1alpha1PipelineTaskArgumentDisplayFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskArgumentDisplayBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskArgumentDisplay(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplayFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplayFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskArgumentDisplay(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplayFluent<?> fluent,V1alpha1PipelineTaskArgumentDisplay instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplayFluent<?> fluent,V1alpha1PipelineTaskArgumentDisplay instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdvanced(instance.isAdvanced());

            fluent.withArgs(instance.getArgs());

            fluent.withDescription(instance.getDescription());

            fluent.withName(instance.getName());

            fluent.withRelated(instance.getRelated());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplay instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskArgumentDisplayBuilder(V1alpha1PipelineTaskArgumentDisplay instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdvanced(instance.isAdvanced());

            this.withArgs(instance.getArgs());

            this.withDescription(instance.getDescription());

            this.withName(instance.getName());

            this.withRelated(instance.getRelated());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskArgumentDisplay build(){
            V1alpha1PipelineTaskArgumentDisplay buildable = new V1alpha1PipelineTaskArgumentDisplay();
            buildable.setAdvanced(fluent.isAdvanced());
            buildable.setArgs(fluent.getArgs());
            buildable.setDescription(fluent.getDescription());
            buildable.setName(fluent.getName());
            buildable.setRelated(fluent.getRelated());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskArgumentDisplayBuilder that = (V1alpha1PipelineTaskArgumentDisplayBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
