package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskArgumentBuilder extends V1alpha1PipelineTaskArgumentFluentImpl<V1alpha1PipelineTaskArgumentBuilder> implements VisitableBuilder<V1alpha1PipelineTaskArgument,V1alpha1PipelineTaskArgumentBuilder>{

    V1alpha1PipelineTaskArgumentFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskArgumentBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskArgumentBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskArgument(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgumentFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgumentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskArgument(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgumentFluent<?> fluent,V1alpha1PipelineTaskArgument instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgumentFluent<?> fluent,V1alpha1PipelineTaskArgument instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefault(instance.getDefault());

            fluent.withDisplay(instance.getDisplay());

            fluent.withName(instance.getName());

            fluent.withRelation(instance.getRelation());

            fluent.withRequired(instance.isRequired());

            fluent.withSchema(instance.getSchema());

            fluent.withValidation(instance.getValidation());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgument instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskArgumentBuilder(V1alpha1PipelineTaskArgument instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefault(instance.getDefault());

            this.withDisplay(instance.getDisplay());

            this.withName(instance.getName());

            this.withRelation(instance.getRelation());

            this.withRequired(instance.isRequired());

            this.withSchema(instance.getSchema());

            this.withValidation(instance.getValidation());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskArgument build(){
            V1alpha1PipelineTaskArgument buildable = new V1alpha1PipelineTaskArgument();
            buildable.setDefault(fluent.getDefault());
            buildable.setDisplay(fluent.getDisplay());
            buildable.setName(fluent.getName());
            buildable.setRelation(fluent.getRelation());
            buildable.setRequired(fluent.isRequired());
            buildable.setSchema(fluent.getSchema());
            buildable.setValidation(fluent.getValidation());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskArgumentBuilder that = (V1alpha1PipelineTaskArgumentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
