package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineLogBuilder extends V1alpha1PipelineLogFluentImpl<V1alpha1PipelineLogBuilder> implements VisitableBuilder<V1alpha1PipelineLog,V1alpha1PipelineLogBuilder>{

    V1alpha1PipelineLogFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineLogBuilder(){
            this(true);
    }
    public V1alpha1PipelineLogBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineLog(), validationEnabled);
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLogFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLogFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineLog(), validationEnabled);
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLogFluent<?> fluent,V1alpha1PipelineLog instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLogFluent<?> fluent,V1alpha1PipelineLog instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMore(instance.isMore());

            fluent.withNextStart(instance.getNextStart());

            fluent.withText(instance.getText());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLog instance){
            this(instance,true);
    }
    public V1alpha1PipelineLogBuilder(V1alpha1PipelineLog instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMore(instance.isMore());

            this.withNextStart(instance.getNextStart());

            this.withText(instance.getText());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineLog build(){
            V1alpha1PipelineLog buildable = new V1alpha1PipelineLog();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMore(fluent.isMore());
            buildable.setNextStart(fluent.getNextStart());
            buildable.setText(fluent.getText());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineLogBuilder that = (V1alpha1PipelineLogBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
