package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PipelineInputOptionsFluentImpl<A extends V1alpha1PipelineInputOptionsFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineInputOptionsFluent<A>{

    private String apiVersion;
    private String kind;
    private Boolean approve;
    private String inputID;
    private List<V1alpha1PipelineParameterBuilder> parameters;
    private String platformApprover;
    private Long stage;
    private Long step;

    public V1alpha1PipelineInputOptionsFluentImpl(){
    }
    public V1alpha1PipelineInputOptionsFluentImpl(V1alpha1PipelineInputOptions instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withApprove(instance.isApprove());

            this.withInputID(instance.getInputID());

            this.withParameters(instance.getParameters());

            this.withPlatformApprover(instance.getPlatformApprover());

            this.withStage(instance.getStage());

            this.withStep(instance.getStep());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public Boolean isApprove(){
            return this.approve;
    }

    public A withApprove(Boolean approve){
            this.approve=approve; return (A) this;
    }

    public Boolean hasApprove(){
            return this.approve != null;
    }

    public A withNewApprove(String arg1){
            return (A)withApprove(new Boolean(arg1));
    }

    public A withNewApprove(boolean arg1){
            return (A)withApprove(new Boolean(arg1));
    }

    public String getInputID(){
            return this.inputID;
    }

    public A withInputID(String inputID){
            this.inputID=inputID; return (A) this;
    }

    public Boolean hasInputID(){
            return this.inputID != null;
    }

    public A withNewInputID(String arg1){
            return (A)withInputID(new String(arg1));
    }

    public A withNewInputID(StringBuilder arg1){
            return (A)withInputID(new String(arg1));
    }

    public A withNewInputID(StringBuffer arg1){
            return (A)withInputID(new String(arg1));
    }

    public A addToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
            if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
             return (A)this;
    }

    public A addToParameters(V1alpha1PipelineParameter... items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<V1alpha1PipelineParameter> items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(V1alpha1PipelineParameter... items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<V1alpha1PipelineParameter> items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineParameter> getParameters(){
            return build(parameters);
    }

    public List<V1alpha1PipelineParameter> buildParameters(){
            return build(parameters);
    }

    public V1alpha1PipelineParameter buildParameter(int index){
            return this.parameters.get(index).build();
    }

    public V1alpha1PipelineParameter buildFirstParameter(){
            return this.parameters.get(0).build();
    }

    public V1alpha1PipelineParameter buildLastParameter(){
            return this.parameters.get(parameters.size() - 1).build();
    }

    public V1alpha1PipelineParameter buildMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParameters(List<V1alpha1PipelineParameter> parameters){
            if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
            if (parameters != null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>(); for (V1alpha1PipelineParameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
    }

    public A withParameters(V1alpha1PipelineParameter... parameters){
            if (this.parameters != null) {this.parameters.clear();}
            if (parameters != null) {for (V1alpha1PipelineParameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public Boolean hasParameters(){
            return parameters != null && !parameters.isEmpty();
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> addNewParameterLike(V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(-1, item);
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> setNewParameterLike(int index,V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(index, item);
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> editParameter(int index){
            if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> editFirstParameter(){
            if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
            return setNewParameterLike(0, buildParameter(0));
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> editLastParameter(){
            int index = parameters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineInputOptionsFluent.ParametersNested<A> editMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<parameters.size();i++) { 
            if (predicate.apply(parameters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public String getPlatformApprover(){
            return this.platformApprover;
    }

    public A withPlatformApprover(String platformApprover){
            this.platformApprover=platformApprover; return (A) this;
    }

    public Boolean hasPlatformApprover(){
            return this.platformApprover != null;
    }

    public A withNewPlatformApprover(String arg1){
            return (A)withPlatformApprover(new String(arg1));
    }

    public A withNewPlatformApprover(StringBuilder arg1){
            return (A)withPlatformApprover(new String(arg1));
    }

    public A withNewPlatformApprover(StringBuffer arg1){
            return (A)withPlatformApprover(new String(arg1));
    }

    public Long getStage(){
            return this.stage;
    }

    public A withStage(Long stage){
            this.stage=stage; return (A) this;
    }

    public Boolean hasStage(){
            return this.stage != null;
    }

    public Long getStep(){
            return this.step;
    }

    public A withStep(Long step){
            this.step=step; return (A) this;
    }

    public Boolean hasStep(){
            return this.step != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineInputOptionsFluentImpl that = (V1alpha1PipelineInputOptionsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (approve != null ? !approve.equals(that.approve) :that.approve != null) return false;
            if (inputID != null ? !inputID.equals(that.inputID) :that.inputID != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            if (platformApprover != null ? !platformApprover.equals(that.platformApprover) :that.platformApprover != null) return false;
            if (stage != null ? !stage.equals(that.stage) :that.stage != null) return false;
            if (step != null ? !step.equals(that.step) :that.step != null) return false;
            return true;
    }


    public class ParametersNestedImpl<N> extends V1alpha1PipelineParameterFluentImpl<V1alpha1PipelineInputOptionsFluent.ParametersNested<N>> implements V1alpha1PipelineInputOptionsFluent.ParametersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineParameterBuilder builder;
        private final int index;
    
            ParametersNestedImpl(int index,V1alpha1PipelineParameter item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineParameterBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineInputOptionsFluentImpl.this.setToParameters(index, builder.build());
    }
    public N endParameter(){
            return and();
    }

}


}
