package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PipelineHookFluentImpl<A extends V1alpha1PipelineHookFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineHookFluent<A>{

    private List<String> events;
    private V1alpha1PipelineHookHTTPRequestBuilder httpRequest;
    private String type;

    public V1alpha1PipelineHookFluentImpl(){
    }
    public V1alpha1PipelineHookFluentImpl(V1alpha1PipelineHook instance){
            this.withEvents(instance.getEvents());

            this.withHttpRequest(instance.getHttpRequest());

            this.withType(instance.getType());

    }

    public A addToEvents(int index,String item){
            if (this.events == null) {this.events = new ArrayList<String>();}
            this.events.add(index, item);
            return (A)this;
    }

    public A setToEvents(int index,String item){
            if (this.events == null) {this.events = new ArrayList<String>();}
            this.events.set(index, item); return (A)this;
    }

    public A addToEvents(String... items){
            if (this.events == null) {this.events = new ArrayList<String>();}
            for (String item : items) {this.events.add(item);} return (A)this;
    }

    public A addAllToEvents(Collection<String> items){
            if (this.events == null) {this.events = new ArrayList<String>();}
            for (String item : items) {this.events.add(item);} return (A)this;
    }

    public A removeFromEvents(String... items){
            for (String item : items) {if (this.events!= null){ this.events.remove(item);}} return (A)this;
    }

    public A removeAllFromEvents(Collection<String> items){
            for (String item : items) {if (this.events!= null){ this.events.remove(item);}} return (A)this;
    }

    public List<String> getEvents(){
            return this.events;
    }

    public String getEvent(int index){
            return this.events.get(index);
    }

    public String getFirstEvent(){
            return this.events.get(0);
    }

    public String getLastEvent(){
            return this.events.get(events.size() - 1);
    }

    public String getMatchingEvent(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: events) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingEvent(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: events) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withEvents(List<String> events){
            if (this.events != null) { _visitables.get("events").removeAll(this.events);}
            if (events != null) {this.events = new ArrayList<String>(); for (String item : events){this.addToEvents(item);}} else { this.events = null;} return (A) this;
    }

    public A withEvents(String... events){
            if (this.events != null) {this.events.clear();}
            if (events != null) {for (String item :events){ this.addToEvents(item);}} return (A) this;
    }

    public Boolean hasEvents(){
            return events != null && !events.isEmpty();
    }

    public A addNewEvent(String arg1){
            return (A)addToEvents(new String(arg1));
    }

    public A addNewEvent(StringBuilder arg1){
            return (A)addToEvents(new String(arg1));
    }

    public A addNewEvent(StringBuffer arg1){
            return (A)addToEvents(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHttpRequest instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineHookHTTPRequest getHttpRequest(){
            return this.httpRequest!=null?this.httpRequest.build():null;
    }

    public V1alpha1PipelineHookHTTPRequest buildHttpRequest(){
            return this.httpRequest!=null?this.httpRequest.build():null;
    }

    public A withHttpRequest(V1alpha1PipelineHookHTTPRequest httpRequest){
            _visitables.get("httpRequest").remove(this.httpRequest);
            if (httpRequest!=null){ this.httpRequest= new V1alpha1PipelineHookHTTPRequestBuilder(httpRequest); _visitables.get("httpRequest").add(this.httpRequest);} return (A) this;
    }

    public Boolean hasHttpRequest(){
            return this.httpRequest != null;
    }

    public V1alpha1PipelineHookFluent.HttpRequestNested<A> withNewHttpRequest(){
            return new HttpRequestNestedImpl();
    }

    public V1alpha1PipelineHookFluent.HttpRequestNested<A> withNewHttpRequestLike(V1alpha1PipelineHookHTTPRequest item){
            return new HttpRequestNestedImpl(item);
    }

    public V1alpha1PipelineHookFluent.HttpRequestNested<A> editHttpRequest(){
            return withNewHttpRequestLike(getHttpRequest());
    }

    public V1alpha1PipelineHookFluent.HttpRequestNested<A> editOrNewHttpRequest(){
            return withNewHttpRequestLike(getHttpRequest() != null ? getHttpRequest(): new V1alpha1PipelineHookHTTPRequestBuilder().build());
    }

    public V1alpha1PipelineHookFluent.HttpRequestNested<A> editOrNewHttpRequestLike(V1alpha1PipelineHookHTTPRequest item){
            return withNewHttpRequestLike(getHttpRequest() != null ? getHttpRequest(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineHookFluentImpl that = (V1alpha1PipelineHookFluentImpl) o;
            if (events != null ? !events.equals(that.events) :that.events != null) return false;
            if (httpRequest != null ? !httpRequest.equals(that.httpRequest) :that.httpRequest != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class HttpRequestNestedImpl<N> extends V1alpha1PipelineHookHTTPRequestFluentImpl<V1alpha1PipelineHookFluent.HttpRequestNested<N>> implements V1alpha1PipelineHookFluent.HttpRequestNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineHookHTTPRequestBuilder builder;
    
            HttpRequestNestedImpl(V1alpha1PipelineHookHTTPRequest item){
                    this.builder = new V1alpha1PipelineHookHTTPRequestBuilder(this, item);
            }
            HttpRequestNestedImpl(){
                    this.builder = new V1alpha1PipelineHookHTTPRequestBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineHookFluentImpl.this.withHttpRequest(builder.build());
    }
    public N endHttpRequest(){
            return and();
    }

}


}
