package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class V1alpha1PipelineConfigSpecFluentImpl<A extends V1alpha1PipelineConfigSpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineConfigSpecFluent<A>{

    private List<V1alpha1PipelineEnvironmentBuilder> environments;
    private List<V1alpha1PipelineHookBuilder> hooks;
    private V1alpha1LocalObjectReferenceBuilder jenkinsBinding;
    private List<V1alpha1PipelineParameterBuilder> parameters;
    private V1alpha1PipelineRunLimitsBuilder runLimits;
    private String runPolicy;
    private V1alpha1PipelineSourceBuilder source;
    private V1alpha1PipelineStrategyBuilder strategy;
    private V1alpha1PipelineTemplateWithValueBuilder template;
    private List<V1alpha1PipelineTriggerBuilder> triggers;

    public V1alpha1PipelineConfigSpecFluentImpl(){
    }
    public V1alpha1PipelineConfigSpecFluentImpl(V1alpha1PipelineConfigSpec instance){
            this.withEnvironments(instance.getEnvironments());

            this.withHooks(instance.getHooks());

            this.withJenkinsBinding(instance.getJenkinsBinding());

            this.withParameters(instance.getParameters());

            this.withRunLimits(instance.getRunLimits());

            this.withRunPolicy(instance.getRunPolicy());

            this.withSource(instance.getSource());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

            this.withTriggers(instance.getTriggers());

    }

    public A addToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(index >= 0 ? index : _visitables.get("environments").size(), builder);this.environments.add(index >= 0 ? index : environments.size(), builder); return (A)this;
    }

    public A setToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);
            if (index < 0 || index >= _visitables.get("environments").size()) { _visitables.get("environments").add(builder); } else { _visitables.get("environments").set(index, builder);}
            if (index < 0 || index >= environments.size()) { environments.add(builder); } else { environments.set(index, builder);}
             return (A)this;
    }

    public A addToEnvironments(V1alpha1PipelineEnvironment... items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A addAllToEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A removeFromEnvironments(V1alpha1PipelineEnvironment... items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvironments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineEnvironment> getEnvironments(){
            return build(environments);
    }

    public List<V1alpha1PipelineEnvironment> buildEnvironments(){
            return build(environments);
    }

    public V1alpha1PipelineEnvironment buildEnvironment(int index){
            return this.environments.get(index).build();
    }

    public V1alpha1PipelineEnvironment buildFirstEnvironment(){
            return this.environments.get(0).build();
    }

    public V1alpha1PipelineEnvironment buildLastEnvironment(){
            return this.environments.get(environments.size() - 1).build();
    }

    public V1alpha1PipelineEnvironment buildMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withEnvironments(List<V1alpha1PipelineEnvironment> environments){
            if (this.environments != null) { _visitables.get("environments").removeAll(this.environments);}
            if (environments != null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>(); for (V1alpha1PipelineEnvironment item : environments){this.addToEnvironments(item);}} else { this.environments = null;} return (A) this;
    }

    public A withEnvironments(V1alpha1PipelineEnvironment... environments){
            if (this.environments != null) {this.environments.clear();}
            if (environments != null) {for (V1alpha1PipelineEnvironment item :environments){ this.addToEnvironments(item);}} return (A) this;
    }

    public Boolean hasEnvironments(){
            return environments != null && !environments.isEmpty();
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> addNewEnvironment(){
            return new EnvironmentsNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> addNewEnvironmentLike(V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> setNewEnvironmentLike(int index,V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(index, item);
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> editEnvironment(int index){
            if (environments.size() <= index) throw new RuntimeException("Can't edit environments. Index exceeds size.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> editFirstEnvironment(){
            if (environments.size() == 0) throw new RuntimeException("Can't edit first environments. The list is empty.");
            return setNewEnvironmentLike(0, buildEnvironment(0));
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> editLastEnvironment(){
            int index = environments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last environments. The list is empty.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<A> editMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            int index = -1;
            for (int i=0;i<environments.size();i++) { 
            if (predicate.apply(environments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching environments. No match found.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public A addToHooks(int index,V1alpha1PipelineHook item){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(index >= 0 ? index : _visitables.get("hooks").size(), builder);this.hooks.add(index >= 0 ? index : hooks.size(), builder); return (A)this;
    }

    public A setToHooks(int index,V1alpha1PipelineHook item){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);
            if (index < 0 || index >= _visitables.get("hooks").size()) { _visitables.get("hooks").add(builder); } else { _visitables.get("hooks").set(index, builder);}
            if (index < 0 || index >= hooks.size()) { hooks.add(builder); } else { hooks.set(index, builder);}
             return (A)this;
    }

    public A addToHooks(V1alpha1PipelineHook... items){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(builder);this.hooks.add(builder);} return (A)this;
    }

    public A addAllToHooks(Collection<V1alpha1PipelineHook> items){
            if (this.hooks == null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>();}
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").add(builder);this.hooks.add(builder);} return (A)this;
    }

    public A removeFromHooks(V1alpha1PipelineHook... items){
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").remove(builder);if (this.hooks != null) {this.hooks.remove(builder);}} return (A)this;
    }

    public A removeAllFromHooks(Collection<V1alpha1PipelineHook> items){
            for (V1alpha1PipelineHook item : items) {V1alpha1PipelineHookBuilder builder = new V1alpha1PipelineHookBuilder(item);_visitables.get("hooks").remove(builder);if (this.hooks != null) {this.hooks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHooks instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineHook> getHooks(){
            return build(hooks);
    }

    public List<V1alpha1PipelineHook> buildHooks(){
            return build(hooks);
    }

    public V1alpha1PipelineHook buildHook(int index){
            return this.hooks.get(index).build();
    }

    public V1alpha1PipelineHook buildFirstHook(){
            return this.hooks.get(0).build();
    }

    public V1alpha1PipelineHook buildLastHook(){
            return this.hooks.get(hooks.size() - 1).build();
    }

    public V1alpha1PipelineHook buildMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            for (V1alpha1PipelineHookBuilder item: hooks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            for (V1alpha1PipelineHookBuilder item: hooks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withHooks(List<V1alpha1PipelineHook> hooks){
            if (this.hooks != null) { _visitables.get("hooks").removeAll(this.hooks);}
            if (hooks != null) {this.hooks = new ArrayList<V1alpha1PipelineHookBuilder>(); for (V1alpha1PipelineHook item : hooks){this.addToHooks(item);}} else { this.hooks = null;} return (A) this;
    }

    public A withHooks(V1alpha1PipelineHook... hooks){
            if (this.hooks != null) {this.hooks.clear();}
            if (hooks != null) {for (V1alpha1PipelineHook item :hooks){ this.addToHooks(item);}} return (A) this;
    }

    public Boolean hasHooks(){
            return hooks != null && !hooks.isEmpty();
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> addNewHook(){
            return new HooksNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> addNewHookLike(V1alpha1PipelineHook item){
            return new HooksNestedImpl(-1, item);
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> setNewHookLike(int index,V1alpha1PipelineHook item){
            return new HooksNestedImpl(index, item);
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> editHook(int index){
            if (hooks.size() <= index) throw new RuntimeException("Can't edit hooks. Index exceeds size.");
            return setNewHookLike(index, buildHook(index));
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> editFirstHook(){
            if (hooks.size() == 0) throw new RuntimeException("Can't edit first hooks. The list is empty.");
            return setNewHookLike(0, buildHook(0));
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> editLastHook(){
            int index = hooks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last hooks. The list is empty.");
            return setNewHookLike(index, buildHook(index));
    }

    public V1alpha1PipelineConfigSpecFluent.HooksNested<A> editMatchingHook(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineHookBuilder> predicate){
            int index = -1;
            for (int i=0;i<hooks.size();i++) { 
            if (predicate.apply(hooks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching hooks. No match found.");
            return setNewHookLike(index, buildHook(index));
    }

    
/**
 * This method has been deprecated, please use method buildJenkinsBinding instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1LocalObjectReference getJenkinsBinding(){
            return this.jenkinsBinding!=null?this.jenkinsBinding.build():null;
    }

    public V1alpha1LocalObjectReference buildJenkinsBinding(){
            return this.jenkinsBinding!=null?this.jenkinsBinding.build():null;
    }

    public A withJenkinsBinding(V1alpha1LocalObjectReference jenkinsBinding){
            _visitables.get("jenkinsBinding").remove(this.jenkinsBinding);
            if (jenkinsBinding!=null){ this.jenkinsBinding= new V1alpha1LocalObjectReferenceBuilder(jenkinsBinding); _visitables.get("jenkinsBinding").add(this.jenkinsBinding);} return (A) this;
    }

    public Boolean hasJenkinsBinding(){
            return this.jenkinsBinding != null;
    }

    public V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<A> withNewJenkinsBinding(){
            return new JenkinsBindingNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<A> withNewJenkinsBindingLike(V1alpha1LocalObjectReference item){
            return new JenkinsBindingNestedImpl(item);
    }

    public V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<A> editJenkinsBinding(){
            return withNewJenkinsBindingLike(getJenkinsBinding());
    }

    public V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBinding(){
            return withNewJenkinsBindingLike(getJenkinsBinding() != null ? getJenkinsBinding(): new V1alpha1LocalObjectReferenceBuilder().build());
    }

    public V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<A> editOrNewJenkinsBindingLike(V1alpha1LocalObjectReference item){
            return withNewJenkinsBindingLike(getJenkinsBinding() != null ? getJenkinsBinding(): item);
    }

    public A addToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
            if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
             return (A)this;
    }

    public A addToParameters(V1alpha1PipelineParameter... items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<V1alpha1PipelineParameter> items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(V1alpha1PipelineParameter... items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<V1alpha1PipelineParameter> items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineParameter> getParameters(){
            return build(parameters);
    }

    public List<V1alpha1PipelineParameter> buildParameters(){
            return build(parameters);
    }

    public V1alpha1PipelineParameter buildParameter(int index){
            return this.parameters.get(index).build();
    }

    public V1alpha1PipelineParameter buildFirstParameter(){
            return this.parameters.get(0).build();
    }

    public V1alpha1PipelineParameter buildLastParameter(){
            return this.parameters.get(parameters.size() - 1).build();
    }

    public V1alpha1PipelineParameter buildMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParameters(List<V1alpha1PipelineParameter> parameters){
            if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
            if (parameters != null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>(); for (V1alpha1PipelineParameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
    }

    public A withParameters(V1alpha1PipelineParameter... parameters){
            if (this.parameters != null) {this.parameters.clear();}
            if (parameters != null) {for (V1alpha1PipelineParameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public Boolean hasParameters(){
            return parameters != null && !parameters.isEmpty();
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> addNewParameterLike(V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(-1, item);
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> setNewParameterLike(int index,V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(index, item);
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> editParameter(int index){
            if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> editFirstParameter(){
            if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
            return setNewParameterLike(0, buildParameter(0));
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> editLastParameter(){
            int index = parameters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineConfigSpecFluent.ParametersNested<A> editMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<parameters.size();i++) { 
            if (predicate.apply(parameters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
            return setNewParameterLike(index, buildParameter(index));
    }

    
/**
 * This method has been deprecated, please use method buildRunLimits instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineRunLimits getRunLimits(){
            return this.runLimits!=null?this.runLimits.build():null;
    }

    public V1alpha1PipelineRunLimits buildRunLimits(){
            return this.runLimits!=null?this.runLimits.build():null;
    }

    public A withRunLimits(V1alpha1PipelineRunLimits runLimits){
            _visitables.get("runLimits").remove(this.runLimits);
            if (runLimits!=null){ this.runLimits= new V1alpha1PipelineRunLimitsBuilder(runLimits); _visitables.get("runLimits").add(this.runLimits);} return (A) this;
    }

    public Boolean hasRunLimits(){
            return this.runLimits != null;
    }

    public V1alpha1PipelineConfigSpecFluent.RunLimitsNested<A> withNewRunLimits(){
            return new RunLimitsNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.RunLimitsNested<A> withNewRunLimitsLike(V1alpha1PipelineRunLimits item){
            return new RunLimitsNestedImpl(item);
    }

    public V1alpha1PipelineConfigSpecFluent.RunLimitsNested<A> editRunLimits(){
            return withNewRunLimitsLike(getRunLimits());
    }

    public V1alpha1PipelineConfigSpecFluent.RunLimitsNested<A> editOrNewRunLimits(){
            return withNewRunLimitsLike(getRunLimits() != null ? getRunLimits(): new V1alpha1PipelineRunLimitsBuilder().build());
    }

    public V1alpha1PipelineConfigSpecFluent.RunLimitsNested<A> editOrNewRunLimitsLike(V1alpha1PipelineRunLimits item){
            return withNewRunLimitsLike(getRunLimits() != null ? getRunLimits(): item);
    }

    public String getRunPolicy(){
            return this.runPolicy;
    }

    public A withRunPolicy(String runPolicy){
            this.runPolicy=runPolicy; return (A) this;
    }

    public Boolean hasRunPolicy(){
            return this.runPolicy != null;
    }

    public A withNewRunPolicy(String arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    public A withNewRunPolicy(StringBuilder arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    public A withNewRunPolicy(StringBuffer arg1){
            return (A)withRunPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSource getSource(){
            return this.source!=null?this.source.build():null;
    }

    public V1alpha1PipelineSource buildSource(){
            return this.source!=null?this.source.build():null;
    }

    public A withSource(V1alpha1PipelineSource source){
            _visitables.get("source").remove(this.source);
            if (source!=null){ this.source= new V1alpha1PipelineSourceBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
    }

    public Boolean hasSource(){
            return this.source != null;
    }

    public V1alpha1PipelineConfigSpecFluent.SourceNested<A> withNewSource(){
            return new SourceNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.SourceNested<A> withNewSourceLike(V1alpha1PipelineSource item){
            return new SourceNestedImpl(item);
    }

    public V1alpha1PipelineConfigSpecFluent.SourceNested<A> editSource(){
            return withNewSourceLike(getSource());
    }

    public V1alpha1PipelineConfigSpecFluent.SourceNested<A> editOrNewSource(){
            return withNewSourceLike(getSource() != null ? getSource(): new V1alpha1PipelineSourceBuilder().build());
    }

    public V1alpha1PipelineConfigSpecFluent.SourceNested<A> editOrNewSourceLike(V1alpha1PipelineSource item){
            return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public V1alpha1PipelineStrategy buildStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(V1alpha1PipelineStrategy strategy){
            _visitables.get("strategy").remove(this.strategy);
            if (strategy!=null){ this.strategy= new V1alpha1PipelineStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
    }

    public Boolean hasStrategy(){
            return this.strategy != null;
    }

    public V1alpha1PipelineConfigSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.StrategyNested<A> withNewStrategyLike(V1alpha1PipelineStrategy item){
            return new StrategyNestedImpl(item);
    }

    public V1alpha1PipelineConfigSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public V1alpha1PipelineConfigSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new V1alpha1PipelineStrategyBuilder().build());
    }

    public V1alpha1PipelineConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(V1alpha1PipelineStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTemplateWithValue getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1alpha1PipelineTemplateWithValue buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1alpha1PipelineTemplateWithValue template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1alpha1PipelineTemplateWithValueBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1alpha1PipelineConfigSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.TemplateNested<A> withNewTemplateLike(V1alpha1PipelineTemplateWithValue item){
            return new TemplateNestedImpl(item);
    }

    public V1alpha1PipelineConfigSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1alpha1PipelineConfigSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1alpha1PipelineTemplateWithValueBuilder().build());
    }

    public V1alpha1PipelineConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1alpha1PipelineTemplateWithValue item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public A addToTriggers(int index,V1alpha1PipelineTrigger item){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(index >= 0 ? index : _visitables.get("triggers").size(), builder);this.triggers.add(index >= 0 ? index : triggers.size(), builder); return (A)this;
    }

    public A setToTriggers(int index,V1alpha1PipelineTrigger item){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);
            if (index < 0 || index >= _visitables.get("triggers").size()) { _visitables.get("triggers").add(builder); } else { _visitables.get("triggers").set(index, builder);}
            if (index < 0 || index >= triggers.size()) { triggers.add(builder); } else { triggers.set(index, builder);}
             return (A)this;
    }

    public A addToTriggers(V1alpha1PipelineTrigger... items){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A addAllToTriggers(Collection<V1alpha1PipelineTrigger> items){
            if (this.triggers == null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>();}
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
    }

    public A removeFromTriggers(V1alpha1PipelineTrigger... items){
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    public A removeAllFromTriggers(Collection<V1alpha1PipelineTrigger> items){
            for (V1alpha1PipelineTrigger item : items) {V1alpha1PipelineTriggerBuilder builder = new V1alpha1PipelineTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTrigger> getTriggers(){
            return build(triggers);
    }

    public List<V1alpha1PipelineTrigger> buildTriggers(){
            return build(triggers);
    }

    public V1alpha1PipelineTrigger buildTrigger(int index){
            return this.triggers.get(index).build();
    }

    public V1alpha1PipelineTrigger buildFirstTrigger(){
            return this.triggers.get(0).build();
    }

    public V1alpha1PipelineTrigger buildLastTrigger(){
            return this.triggers.get(triggers.size() - 1).build();
    }

    public V1alpha1PipelineTrigger buildMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            for (V1alpha1PipelineTriggerBuilder item: triggers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            for (V1alpha1PipelineTriggerBuilder item: triggers) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTriggers(List<V1alpha1PipelineTrigger> triggers){
            if (this.triggers != null) { _visitables.get("triggers").removeAll(this.triggers);}
            if (triggers != null) {this.triggers = new ArrayList<V1alpha1PipelineTriggerBuilder>(); for (V1alpha1PipelineTrigger item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
    }

    public A withTriggers(V1alpha1PipelineTrigger... triggers){
            if (this.triggers != null) {this.triggers.clear();}
            if (triggers != null) {for (V1alpha1PipelineTrigger item :triggers){ this.addToTriggers(item);}} return (A) this;
    }

    public Boolean hasTriggers(){
            return triggers != null && !triggers.isEmpty();
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> addNewTrigger(){
            return new TriggersNestedImpl();
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> addNewTriggerLike(V1alpha1PipelineTrigger item){
            return new TriggersNestedImpl(-1, item);
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> setNewTriggerLike(int index,V1alpha1PipelineTrigger item){
            return new TriggersNestedImpl(index, item);
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> editTrigger(int index){
            if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> editFirstTrigger(){
            if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
            return setNewTriggerLike(0, buildTrigger(0));
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> editLastTrigger(){
            int index = triggers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public V1alpha1PipelineConfigSpecFluent.TriggersNested<A> editMatchingTrigger(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTriggerBuilder> predicate){
            int index = -1;
            for (int i=0;i<triggers.size();i++) { 
            if (predicate.apply(triggers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
            return setNewTriggerLike(index, buildTrigger(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigSpecFluentImpl that = (V1alpha1PipelineConfigSpecFluentImpl) o;
            if (environments != null ? !environments.equals(that.environments) :that.environments != null) return false;
            if (hooks != null ? !hooks.equals(that.hooks) :that.hooks != null) return false;
            if (jenkinsBinding != null ? !jenkinsBinding.equals(that.jenkinsBinding) :that.jenkinsBinding != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            if (runLimits != null ? !runLimits.equals(that.runLimits) :that.runLimits != null) return false;
            if (runPolicy != null ? !runPolicy.equals(that.runPolicy) :that.runPolicy != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
            return true;
    }


    public class EnvironmentsNestedImpl<N> extends V1alpha1PipelineEnvironmentFluentImpl<V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<N>> implements V1alpha1PipelineConfigSpecFluent.EnvironmentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineEnvironmentBuilder builder;
        private final int index;
    
            EnvironmentsNestedImpl(int index,V1alpha1PipelineEnvironment item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this, item);
            }
            EnvironmentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.setToEnvironments(index, builder.build());
    }
    public N endEnvironment(){
            return and();
    }

}
    public class HooksNestedImpl<N> extends V1alpha1PipelineHookFluentImpl<V1alpha1PipelineConfigSpecFluent.HooksNested<N>> implements V1alpha1PipelineConfigSpecFluent.HooksNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineHookBuilder builder;
        private final int index;
    
            HooksNestedImpl(int index,V1alpha1PipelineHook item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineHookBuilder(this, item);
            }
            HooksNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineHookBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.setToHooks(index, builder.build());
    }
    public N endHook(){
            return and();
    }

}
    public class JenkinsBindingNestedImpl<N> extends V1alpha1LocalObjectReferenceFluentImpl<V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<N>> implements V1alpha1PipelineConfigSpecFluent.JenkinsBindingNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1LocalObjectReferenceBuilder builder;
    
            JenkinsBindingNestedImpl(V1alpha1LocalObjectReference item){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this, item);
            }
            JenkinsBindingNestedImpl(){
                    this.builder = new V1alpha1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.withJenkinsBinding(builder.build());
    }
    public N endJenkinsBinding(){
            return and();
    }

}
    public class ParametersNestedImpl<N> extends V1alpha1PipelineParameterFluentImpl<V1alpha1PipelineConfigSpecFluent.ParametersNested<N>> implements V1alpha1PipelineConfigSpecFluent.ParametersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineParameterBuilder builder;
        private final int index;
    
            ParametersNestedImpl(int index,V1alpha1PipelineParameter item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineParameterBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.setToParameters(index, builder.build());
    }
    public N endParameter(){
            return and();
    }

}
    public class RunLimitsNestedImpl<N> extends V1alpha1PipelineRunLimitsFluentImpl<V1alpha1PipelineConfigSpecFluent.RunLimitsNested<N>> implements V1alpha1PipelineConfigSpecFluent.RunLimitsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineRunLimitsBuilder builder;
    
            RunLimitsNestedImpl(V1alpha1PipelineRunLimits item){
                    this.builder = new V1alpha1PipelineRunLimitsBuilder(this, item);
            }
            RunLimitsNestedImpl(){
                    this.builder = new V1alpha1PipelineRunLimitsBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.withRunLimits(builder.build());
    }
    public N endRunLimits(){
            return and();
    }

}
    public class SourceNestedImpl<N> extends V1alpha1PipelineSourceFluentImpl<V1alpha1PipelineConfigSpecFluent.SourceNested<N>> implements V1alpha1PipelineConfigSpecFluent.SourceNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSourceBuilder builder;
    
            SourceNestedImpl(V1alpha1PipelineSource item){
                    this.builder = new V1alpha1PipelineSourceBuilder(this, item);
            }
            SourceNestedImpl(){
                    this.builder = new V1alpha1PipelineSourceBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.withSource(builder.build());
    }
    public N endSource(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends V1alpha1PipelineStrategyFluentImpl<V1alpha1PipelineConfigSpecFluent.StrategyNested<N>> implements V1alpha1PipelineConfigSpecFluent.StrategyNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStrategyBuilder builder;
    
            StrategyNestedImpl(V1alpha1PipelineStrategy item){
                    this.builder = new V1alpha1PipelineStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new V1alpha1PipelineStrategyBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1alpha1PipelineTemplateWithValueFluentImpl<V1alpha1PipelineConfigSpecFluent.TemplateNested<N>> implements V1alpha1PipelineConfigSpecFluent.TemplateNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateWithValueBuilder builder;
    
            TemplateNestedImpl(V1alpha1PipelineTemplateWithValue item){
                    this.builder = new V1alpha1PipelineTemplateWithValueBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1alpha1PipelineTemplateWithValueBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class TriggersNestedImpl<N> extends V1alpha1PipelineTriggerFluentImpl<V1alpha1PipelineConfigSpecFluent.TriggersNested<N>> implements V1alpha1PipelineConfigSpecFluent.TriggersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTriggerBuilder builder;
        private final int index;
    
            TriggersNestedImpl(int index,V1alpha1PipelineTrigger item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTriggerBuilder(this, item);
            }
            TriggersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTriggerBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineConfigSpecFluentImpl.this.setToTriggers(index, builder.build());
    }
    public N endTrigger(){
            return and();
    }

}


}
