package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsBindingProxyOptionsBuilder extends V1alpha1JenkinsBindingProxyOptionsFluentImpl<V1alpha1JenkinsBindingProxyOptionsBuilder> implements VisitableBuilder<V1alpha1JenkinsBindingProxyOptions,V1alpha1JenkinsBindingProxyOptionsBuilder>{

    V1alpha1JenkinsBindingProxyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsBindingProxyOptionsBuilder(){
            this(true);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsBindingProxyOptions(), validationEnabled);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsBindingProxyOptions(), validationEnabled);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptionsFluent<?> fluent,V1alpha1JenkinsBindingProxyOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptionsFluent<?> fluent,V1alpha1JenkinsBindingProxyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withHeader(instance.getHeader());

            fluent.withKind(instance.getKind());

            fluent.withMethod(instance.getMethod());

            fluent.withPayload(instance.getPayload());

            fluent.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptions instance){
            this(instance,true);
    }
    public V1alpha1JenkinsBindingProxyOptionsBuilder(V1alpha1JenkinsBindingProxyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withHeader(instance.getHeader());

            this.withKind(instance.getKind());

            this.withMethod(instance.getMethod());

            this.withPayload(instance.getPayload());

            this.withUrl(instance.getUrl());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsBindingProxyOptions build(){
            V1alpha1JenkinsBindingProxyOptions buildable = new V1alpha1JenkinsBindingProxyOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setHeader(fluent.getHeader());
            buildable.setKind(fluent.getKind());
            buildable.setMethod(fluent.getMethod());
            buildable.setPayload(fluent.getPayload());
            buildable.setUrl(fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingProxyOptionsBuilder that = (V1alpha1JenkinsBindingProxyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
