package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl<A extends V1alpha1ProjectManagementBindingReplicaTemplateFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ProjectManagementBindingReplicaTemplateFluent<A>{

    private List<V1alpha1ProjectManagementProjectInfoBuilder> projects;
    private V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder template;

    public V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl(){
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl(V1alpha1ProjectManagementBindingReplicaTemplate instance){
            this.withProjects(instance.getProjects());

            this.withTemplate(instance.getTemplate());

    }

    public A addToProjects(int index,V1alpha1ProjectManagementProjectInfo item){
            if (this.projects == null) {this.projects = new ArrayList<V1alpha1ProjectManagementProjectInfoBuilder>();}
            V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);_visitables.get("projects").add(index >= 0 ? index : _visitables.get("projects").size(), builder);this.projects.add(index >= 0 ? index : projects.size(), builder); return (A)this;
    }

    public A setToProjects(int index,V1alpha1ProjectManagementProjectInfo item){
            if (this.projects == null) {this.projects = new ArrayList<V1alpha1ProjectManagementProjectInfoBuilder>();}
            V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);
            if (index < 0 || index >= _visitables.get("projects").size()) { _visitables.get("projects").add(builder); } else { _visitables.get("projects").set(index, builder);}
            if (index < 0 || index >= projects.size()) { projects.add(builder); } else { projects.set(index, builder);}
             return (A)this;
    }

    public A addToProjects(V1alpha1ProjectManagementProjectInfo... items){
            if (this.projects == null) {this.projects = new ArrayList<V1alpha1ProjectManagementProjectInfoBuilder>();}
            for (V1alpha1ProjectManagementProjectInfo item : items) {V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);_visitables.get("projects").add(builder);this.projects.add(builder);} return (A)this;
    }

    public A addAllToProjects(Collection<V1alpha1ProjectManagementProjectInfo> items){
            if (this.projects == null) {this.projects = new ArrayList<V1alpha1ProjectManagementProjectInfoBuilder>();}
            for (V1alpha1ProjectManagementProjectInfo item : items) {V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);_visitables.get("projects").add(builder);this.projects.add(builder);} return (A)this;
    }

    public A removeFromProjects(V1alpha1ProjectManagementProjectInfo... items){
            for (V1alpha1ProjectManagementProjectInfo item : items) {V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);_visitables.get("projects").remove(builder);if (this.projects != null) {this.projects.remove(builder);}} return (A)this;
    }

    public A removeAllFromProjects(Collection<V1alpha1ProjectManagementProjectInfo> items){
            for (V1alpha1ProjectManagementProjectInfo item : items) {V1alpha1ProjectManagementProjectInfoBuilder builder = new V1alpha1ProjectManagementProjectInfoBuilder(item);_visitables.get("projects").remove(builder);if (this.projects != null) {this.projects.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildProjects instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1ProjectManagementProjectInfo> getProjects(){
            return build(projects);
    }

    public List<V1alpha1ProjectManagementProjectInfo> buildProjects(){
            return build(projects);
    }

    public V1alpha1ProjectManagementProjectInfo buildProject(int index){
            return this.projects.get(index).build();
    }

    public V1alpha1ProjectManagementProjectInfo buildFirstProject(){
            return this.projects.get(0).build();
    }

    public V1alpha1ProjectManagementProjectInfo buildLastProject(){
            return this.projects.get(projects.size() - 1).build();
    }

    public V1alpha1ProjectManagementProjectInfo buildMatchingProject(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectManagementProjectInfoBuilder> predicate){
            for (V1alpha1ProjectManagementProjectInfoBuilder item: projects) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingProject(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectManagementProjectInfoBuilder> predicate){
            for (V1alpha1ProjectManagementProjectInfoBuilder item: projects) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withProjects(List<V1alpha1ProjectManagementProjectInfo> projects){
            if (this.projects != null) { _visitables.get("projects").removeAll(this.projects);}
            if (projects != null) {this.projects = new ArrayList<V1alpha1ProjectManagementProjectInfoBuilder>(); for (V1alpha1ProjectManagementProjectInfo item : projects){this.addToProjects(item);}} else { this.projects = null;} return (A) this;
    }

    public A withProjects(V1alpha1ProjectManagementProjectInfo... projects){
            if (this.projects != null) {this.projects.clear();}
            if (projects != null) {for (V1alpha1ProjectManagementProjectInfo item :projects){ this.addToProjects(item);}} return (A) this;
    }

    public Boolean hasProjects(){
            return projects != null && !projects.isEmpty();
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> addNewProject(){
            return new ProjectsNestedImpl();
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> addNewProjectLike(V1alpha1ProjectManagementProjectInfo item){
            return new ProjectsNestedImpl(-1, item);
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> setNewProjectLike(int index,V1alpha1ProjectManagementProjectInfo item){
            return new ProjectsNestedImpl(index, item);
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> editProject(int index){
            if (projects.size() <= index) throw new RuntimeException("Can't edit projects. Index exceeds size.");
            return setNewProjectLike(index, buildProject(index));
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> editFirstProject(){
            if (projects.size() == 0) throw new RuntimeException("Can't edit first projects. The list is empty.");
            return setNewProjectLike(0, buildProject(0));
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> editLastProject(){
            int index = projects.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last projects. The list is empty.");
            return setNewProjectLike(index, buildProject(index));
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<A> editMatchingProject(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ProjectManagementProjectInfoBuilder> predicate){
            int index = -1;
            for (int i=0;i<projects.size();i++) { 
            if (predicate.apply(projects.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching projects. No match found.");
            return setNewProjectLike(index, buildProject(index));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ProjectManagementBindingReplicaTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1alpha1ProjectManagementBindingReplicaTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplateLike(V1alpha1ProjectManagementBindingReplicaTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder().build());
    }

    public V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplateLike(V1alpha1ProjectManagementBindingReplicaTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl that = (V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl) o;
            if (projects != null ? !projects.equals(that.projects) :that.projects != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class ProjectsNestedImpl<N> extends V1alpha1ProjectManagementProjectInfoFluentImpl<V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<N>> implements V1alpha1ProjectManagementBindingReplicaTemplateFluent.ProjectsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ProjectManagementProjectInfoBuilder builder;
        private final int index;
    
            ProjectsNestedImpl(int index,V1alpha1ProjectManagementProjectInfo item){
                    this.index = index;
                    this.builder = new V1alpha1ProjectManagementProjectInfoBuilder(this, item);
            }
            ProjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ProjectManagementProjectInfoBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl.this.setToProjects(index, builder.build());
    }
    public N endProject(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1alpha1ProjectManagementBindingReplicaTemplateSpecFluentImpl<V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<N>> implements V1alpha1ProjectManagementBindingReplicaTemplateFluent.TemplateNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1alpha1ProjectManagementBindingReplicaTemplateSpec item){
                    this.builder = new V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1alpha1ProjectManagementBindingReplicaTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
