package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineBlueOceanTaskBuilder extends V1alpha1PipelineBlueOceanTaskFluentImpl<V1alpha1PipelineBlueOceanTaskBuilder> implements VisitableBuilder<V1alpha1PipelineBlueOceanTask,V1alpha1PipelineBlueOceanTaskBuilder>{

    V1alpha1PipelineBlueOceanTaskFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineBlueOceanTaskBuilder(){
            this(true);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineBlueOceanTask(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTaskFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTaskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineBlueOceanTask(), validationEnabled);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTaskFluent<?> fluent,V1alpha1PipelineBlueOceanTask instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTaskFluent<?> fluent,V1alpha1PipelineBlueOceanTask instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            fluent.withActions(instance.getActions());

            fluent.withDisplayDescription(instance.getDisplayDescription());

            fluent.withDisplayName(instance.getDisplayName());

            fluent.withDurationInMillis(instance.getDurationInMillis());

            fluent.withEdges(instance.getEdges());

            fluent.withInput(instance.getInput());

            fluent.withResult(instance.getResult());

            fluent.withStartTime(instance.getStartTime());

            fluent.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTask instance){
            this(instance,true);
    }
    public V1alpha1PipelineBlueOceanTaskBuilder(V1alpha1PipelineBlueOceanTask instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPipelineBlueOceanRef(instance.getPipelineBlueOceanRef());

            this.withActions(instance.getActions());

            this.withDisplayDescription(instance.getDisplayDescription());

            this.withDisplayName(instance.getDisplayName());

            this.withDurationInMillis(instance.getDurationInMillis());

            this.withEdges(instance.getEdges());

            this.withInput(instance.getInput());

            this.withResult(instance.getResult());

            this.withStartTime(instance.getStartTime());

            this.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineBlueOceanTask build(){
            V1alpha1PipelineBlueOceanTask buildable = new V1alpha1PipelineBlueOceanTask();
            buildable.setPipelineBlueOceanRef(fluent.getPipelineBlueOceanRef());
            buildable.setActions(fluent.getActions());
            buildable.setDisplayDescription(fluent.getDisplayDescription());
            buildable.setDisplayName(fluent.getDisplayName());
            buildable.setDurationInMillis(fluent.getDurationInMillis());
            buildable.setEdges(fluent.getEdges());
            buildable.setInput(fluent.getInput());
            buildable.setResult(fluent.getResult());
            buildable.setStartTime(fluent.getStartTime());
            buildable.setState(fluent.getState());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineBlueOceanTaskBuilder that = (V1alpha1PipelineBlueOceanTaskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
