package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import io.kubernetes.client.models.V1ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1JenkinsListFluentImpl<A extends V1alpha1JenkinsListFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1JenkinsListFluent<A>{

    private String apiVersion;
    private List<V1alpha1JenkinsBuilder> items;
    private String kind;
    private V1ListMeta metadata;

    public V1alpha1JenkinsListFluentImpl(){
    }
    public V1alpha1JenkinsListFluentImpl(V1alpha1JenkinsList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,V1alpha1Jenkins item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1JenkinsBuilder>();}
            V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1alpha1Jenkins item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1JenkinsBuilder>();}
            V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1alpha1Jenkins... items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1JenkinsBuilder>();}
            for (V1alpha1Jenkins item : items) {V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1alpha1Jenkins> items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1JenkinsBuilder>();}
            for (V1alpha1Jenkins item : items) {V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1alpha1Jenkins... items){
            for (V1alpha1Jenkins item : items) {V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1alpha1Jenkins> items){
            for (V1alpha1Jenkins item : items) {V1alpha1JenkinsBuilder builder = new V1alpha1JenkinsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Jenkins> getItems(){
            return build(items);
    }

    public List<V1alpha1Jenkins> buildItems(){
            return build(items);
    }

    public V1alpha1Jenkins buildItem(int index){
            return this.items.get(index).build();
    }

    public V1alpha1Jenkins buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1alpha1Jenkins buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1alpha1Jenkins buildMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1JenkinsBuilder> predicate){
            for (V1alpha1JenkinsBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1JenkinsBuilder> predicate){
            for (V1alpha1JenkinsBuilder item: items) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withItems(List<V1alpha1Jenkins> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1alpha1JenkinsBuilder>(); for (V1alpha1Jenkins item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1alpha1Jenkins... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1alpha1Jenkins item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> addNewItemLike(V1alpha1Jenkins item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> setNewItemLike(int index,V1alpha1Jenkins item){
            return new ItemsNestedImpl(index, item);
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1JenkinsListFluent.ItemsNested<A> editMatchingItem(io.alauda.devops.java.client.fluent.Predicate<V1alpha1JenkinsBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsListFluentImpl that = (V1alpha1JenkinsListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1alpha1JenkinsFluentImpl<V1alpha1JenkinsListFluent.ItemsNested<N>> implements V1alpha1JenkinsListFluent.ItemsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1alpha1Jenkins item){
                    this.index = index;
                    this.builder = new V1alpha1JenkinsBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1JenkinsBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1JenkinsListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
