package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsBindingBuilder extends V1alpha1JenkinsBindingFluentImpl<V1alpha1JenkinsBindingBuilder> implements VisitableBuilder<V1alpha1JenkinsBinding,V1alpha1JenkinsBindingBuilder>{

    V1alpha1JenkinsBindingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsBindingBuilder(){
            this(true);
    }
    public V1alpha1JenkinsBindingBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsBinding(), validationEnabled);
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBindingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsBinding(), validationEnabled);
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBindingFluent<?> fluent,V1alpha1JenkinsBinding instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBindingFluent<?> fluent,V1alpha1JenkinsBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBinding instance){
            this(instance,true);
    }
    public V1alpha1JenkinsBindingBuilder(V1alpha1JenkinsBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsBinding build(){
            V1alpha1JenkinsBinding buildable = new V1alpha1JenkinsBinding();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingBuilder that = (V1alpha1JenkinsBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
