package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRepositorySpecBuilder extends V1alpha1ImageRepositorySpecFluentImpl<V1alpha1ImageRepositorySpecBuilder> implements VisitableBuilder<V1alpha1ImageRepositorySpec,V1alpha1ImageRepositorySpecBuilder>{

    V1alpha1ImageRepositorySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRepositorySpecBuilder(){
            this(true);
    }
    public V1alpha1ImageRepositorySpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRepositorySpec(), validationEnabled);
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRepositorySpec(), validationEnabled);
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpecFluent<?> fluent,V1alpha1ImageRepositorySpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpecFluent<?> fluent,V1alpha1ImageRepositorySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImage(instance.getImage());

            fluent.withImageRegistry(instance.getImageRegistry());

            fluent.withImageRegistryBinding(instance.getImageRegistryBinding());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpec instance){
            this(instance,true);
    }
    public V1alpha1ImageRepositorySpecBuilder(V1alpha1ImageRepositorySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImage(instance.getImage());

            this.withImageRegistry(instance.getImageRegistry());

            this.withImageRegistryBinding(instance.getImageRegistryBinding());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRepositorySpec build(){
            V1alpha1ImageRepositorySpec buildable = new V1alpha1ImageRepositorySpec();
            buildable.setImage(fluent.getImage());
            buildable.setImageRegistry(fluent.getImageRegistry());
            buildable.setImageRegistryBinding(fluent.getImageRegistryBinding());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRepositorySpecBuilder that = (V1alpha1ImageRepositorySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
