package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingSpecBuilder extends V1alpha1ImageRegistryBindingSpecFluentImpl<V1alpha1ImageRegistryBindingSpecBuilder> implements VisitableBuilder<V1alpha1ImageRegistryBindingSpec,V1alpha1ImageRegistryBindingSpecBuilder>{

    V1alpha1ImageRegistryBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryBindingSpec(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryBindingSpec(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpecFluent<?> fluent,V1alpha1ImageRegistryBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpecFluent<?> fluent,V1alpha1ImageRegistryBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImageRegistry(instance.getImageRegistry());

            fluent.withRepoInfo(instance.getRepoInfo());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryBindingSpecBuilder(V1alpha1ImageRegistryBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImageRegistry(instance.getImageRegistry());

            this.withRepoInfo(instance.getRepoInfo());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryBindingSpec build(){
            V1alpha1ImageRegistryBindingSpec buildable = new V1alpha1ImageRegistryBindingSpec();
            buildable.setImageRegistry(fluent.getImageRegistry());
            buildable.setRepoInfo(fluent.getRepoInfo());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingSpecBuilder that = (V1alpha1ImageRegistryBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
