package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingReplicaTemplateBuilder extends V1alpha1ImageRegistryBindingReplicaTemplateFluentImpl<V1alpha1ImageRegistryBindingReplicaTemplateBuilder> implements VisitableBuilder<V1alpha1ImageRegistryBindingReplicaTemplate,V1alpha1ImageRegistryBindingReplicaTemplateBuilder>{

    V1alpha1ImageRegistryBindingReplicaTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplateFluent<?> fluent,V1alpha1ImageRegistryBindingReplicaTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplateFluent<?> fluent,V1alpha1ImageRegistryBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRepoInfo(instance.getRepoInfo());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplate instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryBindingReplicaTemplateBuilder(V1alpha1ImageRegistryBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRepoInfo(instance.getRepoInfo());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryBindingReplicaTemplate build(){
            V1alpha1ImageRegistryBindingReplicaTemplate buildable = new V1alpha1ImageRegistryBindingReplicaTemplate();
            buildable.setRepoInfo(fluent.getRepoInfo());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingReplicaTemplateBuilder that = (V1alpha1ImageRegistryBindingReplicaTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
