package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryOwnerFluentImpl<A extends V1alpha1CodeRepositoryOwnerFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepositoryOwnerFluent<A>{

    private String avatarURL;
    private Integer diskUsage;
    private String email;
    private String htmlURL;
    private String id;
    private String name;
    private List<V1alpha1OriginCodeRepositoryBuilder> repositories;
    private String type;

    public V1alpha1CodeRepositoryOwnerFluentImpl(){
    }
    public V1alpha1CodeRepositoryOwnerFluentImpl(V1alpha1CodeRepositoryOwner instance){
            this.withAvatarURL(instance.getAvatarURL());

            this.withDiskUsage(instance.getDiskUsage());

            this.withEmail(instance.getEmail());

            this.withHtmlURL(instance.getHtmlURL());

            this.withId(instance.getId());

            this.withName(instance.getName());

            this.withRepositories(instance.getRepositories());

            this.withType(instance.getType());

    }

    public String getAvatarURL(){
            return this.avatarURL;
    }

    public A withAvatarURL(String avatarURL){
            this.avatarURL=avatarURL; return (A) this;
    }

    public Boolean hasAvatarURL(){
            return this.avatarURL != null;
    }

    public A withNewAvatarURL(String arg1){
            return (A)withAvatarURL(new String(arg1));
    }

    public A withNewAvatarURL(StringBuilder arg1){
            return (A)withAvatarURL(new String(arg1));
    }

    public A withNewAvatarURL(StringBuffer arg1){
            return (A)withAvatarURL(new String(arg1));
    }

    public Integer getDiskUsage(){
            return this.diskUsage;
    }

    public A withDiskUsage(Integer diskUsage){
            this.diskUsage=diskUsage; return (A) this;
    }

    public Boolean hasDiskUsage(){
            return this.diskUsage != null;
    }

    public String getEmail(){
            return this.email;
    }

    public A withEmail(String email){
            this.email=email; return (A) this;
    }

    public Boolean hasEmail(){
            return this.email != null;
    }

    public A withNewEmail(String arg1){
            return (A)withEmail(new String(arg1));
    }

    public A withNewEmail(StringBuilder arg1){
            return (A)withEmail(new String(arg1));
    }

    public A withNewEmail(StringBuffer arg1){
            return (A)withEmail(new String(arg1));
    }

    public String getHtmlURL(){
            return this.htmlURL;
    }

    public A withHtmlURL(String htmlURL){
            this.htmlURL=htmlURL; return (A) this;
    }

    public Boolean hasHtmlURL(){
            return this.htmlURL != null;
    }

    public A withNewHtmlURL(String arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public A withNewHtmlURL(StringBuilder arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public A withNewHtmlURL(StringBuffer arg1){
            return (A)withHtmlURL(new String(arg1));
    }

    public String getId(){
            return this.id;
    }

    public A withId(String id){
            this.id=id; return (A) this;
    }

    public Boolean hasId(){
            return this.id != null;
    }

    public A withNewId(String arg1){
            return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuilder arg1){
            return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuffer arg1){
            return (A)withId(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToRepositories(int index,V1alpha1OriginCodeRepository item){
            if (this.repositories == null) {this.repositories = new ArrayList<V1alpha1OriginCodeRepositoryBuilder>();}
            V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);_visitables.get("repositories").add(index >= 0 ? index : _visitables.get("repositories").size(), builder);this.repositories.add(index >= 0 ? index : repositories.size(), builder); return (A)this;
    }

    public A setToRepositories(int index,V1alpha1OriginCodeRepository item){
            if (this.repositories == null) {this.repositories = new ArrayList<V1alpha1OriginCodeRepositoryBuilder>();}
            V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);
            if (index < 0 || index >= _visitables.get("repositories").size()) { _visitables.get("repositories").add(builder); } else { _visitables.get("repositories").set(index, builder);}
            if (index < 0 || index >= repositories.size()) { repositories.add(builder); } else { repositories.set(index, builder);}
             return (A)this;
    }

    public A addToRepositories(V1alpha1OriginCodeRepository... items){
            if (this.repositories == null) {this.repositories = new ArrayList<V1alpha1OriginCodeRepositoryBuilder>();}
            for (V1alpha1OriginCodeRepository item : items) {V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
    }

    public A addAllToRepositories(Collection<V1alpha1OriginCodeRepository> items){
            if (this.repositories == null) {this.repositories = new ArrayList<V1alpha1OriginCodeRepositoryBuilder>();}
            for (V1alpha1OriginCodeRepository item : items) {V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);_visitables.get("repositories").add(builder);this.repositories.add(builder);} return (A)this;
    }

    public A removeFromRepositories(V1alpha1OriginCodeRepository... items){
            for (V1alpha1OriginCodeRepository item : items) {V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
    }

    public A removeAllFromRepositories(Collection<V1alpha1OriginCodeRepository> items){
            for (V1alpha1OriginCodeRepository item : items) {V1alpha1OriginCodeRepositoryBuilder builder = new V1alpha1OriginCodeRepositoryBuilder(item);_visitables.get("repositories").remove(builder);if (this.repositories != null) {this.repositories.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRepositories instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1OriginCodeRepository> getRepositories(){
            return build(repositories);
    }

    public List<V1alpha1OriginCodeRepository> buildRepositories(){
            return build(repositories);
    }

    public V1alpha1OriginCodeRepository buildRepository(int index){
            return this.repositories.get(index).build();
    }

    public V1alpha1OriginCodeRepository buildFirstRepository(){
            return this.repositories.get(0).build();
    }

    public V1alpha1OriginCodeRepository buildLastRepository(){
            return this.repositories.get(repositories.size() - 1).build();
    }

    public V1alpha1OriginCodeRepository buildMatchingRepository(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OriginCodeRepositoryBuilder> predicate){
            for (V1alpha1OriginCodeRepositoryBuilder item: repositories) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRepository(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OriginCodeRepositoryBuilder> predicate){
            for (V1alpha1OriginCodeRepositoryBuilder item: repositories) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRepositories(List<V1alpha1OriginCodeRepository> repositories){
            if (this.repositories != null) { _visitables.get("repositories").removeAll(this.repositories);}
            if (repositories != null) {this.repositories = new ArrayList<V1alpha1OriginCodeRepositoryBuilder>(); for (V1alpha1OriginCodeRepository item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
    }

    public A withRepositories(V1alpha1OriginCodeRepository... repositories){
            if (this.repositories != null) {this.repositories.clear();}
            if (repositories != null) {for (V1alpha1OriginCodeRepository item :repositories){ this.addToRepositories(item);}} return (A) this;
    }

    public Boolean hasRepositories(){
            return repositories != null && !repositories.isEmpty();
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> addNewRepository(){
            return new RepositoriesNestedImpl();
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> addNewRepositoryLike(V1alpha1OriginCodeRepository item){
            return new RepositoriesNestedImpl(-1, item);
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> setNewRepositoryLike(int index,V1alpha1OriginCodeRepository item){
            return new RepositoriesNestedImpl(index, item);
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> editRepository(int index){
            if (repositories.size() <= index) throw new RuntimeException("Can't edit repositories. Index exceeds size.");
            return setNewRepositoryLike(index, buildRepository(index));
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> editFirstRepository(){
            if (repositories.size() == 0) throw new RuntimeException("Can't edit first repositories. The list is empty.");
            return setNewRepositoryLike(0, buildRepository(0));
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> editLastRepository(){
            int index = repositories.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last repositories. The list is empty.");
            return setNewRepositoryLike(index, buildRepository(index));
    }

    public V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<A> editMatchingRepository(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OriginCodeRepositoryBuilder> predicate){
            int index = -1;
            for (int i=0;i<repositories.size();i++) { 
            if (predicate.apply(repositories.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching repositories. No match found.");
            return setNewRepositoryLike(index, buildRepository(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryOwnerFluentImpl that = (V1alpha1CodeRepositoryOwnerFluentImpl) o;
            if (avatarURL != null ? !avatarURL.equals(that.avatarURL) :that.avatarURL != null) return false;
            if (diskUsage != null ? !diskUsage.equals(that.diskUsage) :that.diskUsage != null) return false;
            if (email != null ? !email.equals(that.email) :that.email != null) return false;
            if (htmlURL != null ? !htmlURL.equals(that.htmlURL) :that.htmlURL != null) return false;
            if (id != null ? !id.equals(that.id) :that.id != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (repositories != null ? !repositories.equals(that.repositories) :that.repositories != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class RepositoriesNestedImpl<N> extends V1alpha1OriginCodeRepositoryFluentImpl<V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<N>> implements V1alpha1CodeRepositoryOwnerFluent.RepositoriesNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1OriginCodeRepositoryBuilder builder;
        private final int index;
    
            RepositoriesNestedImpl(int index,V1alpha1OriginCodeRepository item){
                    this.index = index;
                    this.builder = new V1alpha1OriginCodeRepositoryBuilder(this, item);
            }
            RepositoriesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1OriginCodeRepositoryBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepositoryOwnerFluentImpl.this.setToRepositories(index, builder.build());
    }
    public N endRepository(){
            return and();
    }

}


}
