package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingAccountFluentImpl<A extends V1alpha1CodeRepoBindingAccountFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepoBindingAccountFluent<A>{

    private List<V1alpha1CodeRepositoryOwnerSyncBuilder> owners;
    private V1alpha1SecretKeySetRefBuilder secret;

    public V1alpha1CodeRepoBindingAccountFluentImpl(){
    }
    public V1alpha1CodeRepoBindingAccountFluentImpl(V1alpha1CodeRepoBindingAccount instance){
            this.withOwners(instance.getOwners());

            this.withSecret(instance.getSecret());

    }

    public A addToOwners(int index,V1alpha1CodeRepositoryOwnerSync item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerSyncBuilder>();}
            V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);_visitables.get("owners").add(index >= 0 ? index : _visitables.get("owners").size(), builder);this.owners.add(index >= 0 ? index : owners.size(), builder); return (A)this;
    }

    public A setToOwners(int index,V1alpha1CodeRepositoryOwnerSync item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerSyncBuilder>();}
            V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);
            if (index < 0 || index >= _visitables.get("owners").size()) { _visitables.get("owners").add(builder); } else { _visitables.get("owners").set(index, builder);}
            if (index < 0 || index >= owners.size()) { owners.add(builder); } else { owners.set(index, builder);}
             return (A)this;
    }

    public A addToOwners(V1alpha1CodeRepositoryOwnerSync... items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerSyncBuilder>();}
            for (V1alpha1CodeRepositoryOwnerSync item : items) {V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A addAllToOwners(Collection<V1alpha1CodeRepositoryOwnerSync> items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerSyncBuilder>();}
            for (V1alpha1CodeRepositoryOwnerSync item : items) {V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A removeFromOwners(V1alpha1CodeRepositoryOwnerSync... items){
            for (V1alpha1CodeRepositoryOwnerSync item : items) {V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwners(Collection<V1alpha1CodeRepositoryOwnerSync> items){
            for (V1alpha1CodeRepositoryOwnerSync item : items) {V1alpha1CodeRepositoryOwnerSyncBuilder builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwners instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1CodeRepositoryOwnerSync> getOwners(){
            return build(owners);
    }

    public List<V1alpha1CodeRepositoryOwnerSync> buildOwners(){
            return build(owners);
    }

    public V1alpha1CodeRepositoryOwnerSync buildOwner(int index){
            return this.owners.get(index).build();
    }

    public V1alpha1CodeRepositoryOwnerSync buildFirstOwner(){
            return this.owners.get(0).build();
    }

    public V1alpha1CodeRepositoryOwnerSync buildLastOwner(){
            return this.owners.get(owners.size() - 1).build();
    }

    public V1alpha1CodeRepositoryOwnerSync buildMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerSyncBuilder> predicate){
            for (V1alpha1CodeRepositoryOwnerSyncBuilder item: owners) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerSyncBuilder> predicate){
            for (V1alpha1CodeRepositoryOwnerSyncBuilder item: owners) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withOwners(List<V1alpha1CodeRepositoryOwnerSync> owners){
            if (this.owners != null) { _visitables.get("owners").removeAll(this.owners);}
            if (owners != null) {this.owners = new ArrayList<V1alpha1CodeRepositoryOwnerSyncBuilder>(); for (V1alpha1CodeRepositoryOwnerSync item : owners){this.addToOwners(item);}} else { this.owners = null;} return (A) this;
    }

    public A withOwners(V1alpha1CodeRepositoryOwnerSync... owners){
            if (this.owners != null) {this.owners.clear();}
            if (owners != null) {for (V1alpha1CodeRepositoryOwnerSync item :owners){ this.addToOwners(item);}} return (A) this;
    }

    public Boolean hasOwners(){
            return owners != null && !owners.isEmpty();
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> addNewOwner(){
            return new OwnersNestedImpl();
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> addNewOwnerLike(V1alpha1CodeRepositoryOwnerSync item){
            return new OwnersNestedImpl(-1, item);
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> setNewOwnerLike(int index,V1alpha1CodeRepositoryOwnerSync item){
            return new OwnersNestedImpl(index, item);
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> editOwner(int index){
            if (owners.size() <= index) throw new RuntimeException("Can't edit owners. Index exceeds size.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> editFirstOwner(){
            if (owners.size() == 0) throw new RuntimeException("Can't edit first owners. The list is empty.");
            return setNewOwnerLike(0, buildOwner(0));
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> editLastOwner(){
            int index = owners.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last owners. The list is empty.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingAccountFluent.OwnersNested<A> editMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1CodeRepositoryOwnerSyncBuilder> predicate){
            int index = -1;
            for (int i=0;i<owners.size();i++) { 
            if (predicate.apply(owners.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching owners. No match found.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    
/**
 * This method has been deprecated, please use method buildSecret instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1SecretKeySetRef getSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public V1alpha1SecretKeySetRef buildSecret(){
            return this.secret!=null?this.secret.build():null;
    }

    public A withSecret(V1alpha1SecretKeySetRef secret){
            _visitables.get("secret").remove(this.secret);
            if (secret!=null){ this.secret= new V1alpha1SecretKeySetRefBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
    }

    public Boolean hasSecret(){
            return this.secret != null;
    }

    public V1alpha1CodeRepoBindingAccountFluent.SecretNested<A> withNewSecret(){
            return new SecretNestedImpl();
    }

    public V1alpha1CodeRepoBindingAccountFluent.SecretNested<A> withNewSecretLike(V1alpha1SecretKeySetRef item){
            return new SecretNestedImpl(item);
    }

    public V1alpha1CodeRepoBindingAccountFluent.SecretNested<A> editSecret(){
            return withNewSecretLike(getSecret());
    }

    public V1alpha1CodeRepoBindingAccountFluent.SecretNested<A> editOrNewSecret(){
            return withNewSecretLike(getSecret() != null ? getSecret(): new V1alpha1SecretKeySetRefBuilder().build());
    }

    public V1alpha1CodeRepoBindingAccountFluent.SecretNested<A> editOrNewSecretLike(V1alpha1SecretKeySetRef item){
            return withNewSecretLike(getSecret() != null ? getSecret(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingAccountFluentImpl that = (V1alpha1CodeRepoBindingAccountFluentImpl) o;
            if (owners != null ? !owners.equals(that.owners) :that.owners != null) return false;
            if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
            return true;
    }


    public class OwnersNestedImpl<N> extends V1alpha1CodeRepositoryOwnerSyncFluentImpl<V1alpha1CodeRepoBindingAccountFluent.OwnersNested<N>> implements V1alpha1CodeRepoBindingAccountFluent.OwnersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1CodeRepositoryOwnerSyncBuilder builder;
        private final int index;
    
            OwnersNestedImpl(int index,V1alpha1CodeRepositoryOwnerSync item){
                    this.index = index;
                    this.builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(this, item);
            }
            OwnersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1CodeRepositoryOwnerSyncBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingAccountFluentImpl.this.setToOwners(index, builder.build());
    }
    public N endOwner(){
            return and();
    }

}
    public class SecretNestedImpl<N> extends V1alpha1SecretKeySetRefFluentImpl<V1alpha1CodeRepoBindingAccountFluent.SecretNested<N>> implements V1alpha1CodeRepoBindingAccountFluent.SecretNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1SecretKeySetRefBuilder builder;
    
            SecretNestedImpl(V1alpha1SecretKeySetRef item){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this, item);
            }
            SecretNestedImpl(){
                    this.builder = new V1alpha1SecretKeySetRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingAccountFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret(){
            return and();
    }

}


}
