package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterPipelineTemplateBuilder extends V1alpha1ClusterPipelineTemplateFluentImpl<V1alpha1ClusterPipelineTemplateBuilder> implements VisitableBuilder<V1alpha1ClusterPipelineTemplate,V1alpha1ClusterPipelineTemplateBuilder>{

    V1alpha1ClusterPipelineTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ClusterPipelineTemplateBuilder(){
            this(true);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1ClusterPipelineTemplate(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ClusterPipelineTemplate(), validationEnabled);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplateFluent<?> fluent,V1alpha1ClusterPipelineTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplateFluent<?> fluent,V1alpha1ClusterPipelineTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplate instance){
            this(instance,true);
    }
    public V1alpha1ClusterPipelineTemplateBuilder(V1alpha1ClusterPipelineTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ClusterPipelineTemplate build(){
            V1alpha1ClusterPipelineTemplate buildable = new V1alpha1ClusterPipelineTemplate();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterPipelineTemplateBuilder that = (V1alpha1ClusterPipelineTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
