/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.models.V1alpha1ConstValues;
import io.alauda.devops.java.client.models.V1alpha1JenkinsAgent;
import io.alauda.devops.java.client.models.V1alpha1PipelineEnvironment;
import io.alauda.devops.java.client.models.V1alpha1PipelineOptions;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameter;
import io.alauda.devops.java.client.models.V1alpha1PipelineStage;
import io.alauda.devops.java.client.models.V1alpha1PipelineTemplateArgumentGroup;
import io.alauda.devops.java.client.models.V1alpha1PipelineTemplateTask;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="PipelineTemplateSpec represents PipelineTemplate's specs")
public class V1alpha1PipelineTemplateSpec {
    @SerializedName(value="agent")
    private V1alpha1JenkinsAgent agent = null;
    @SerializedName(value="arguments")
    private List<V1alpha1PipelineTemplateArgumentGroup> arguments = null;
    @SerializedName(value="engine")
    private String engine = null;
    @SerializedName(value="environments")
    private List<V1alpha1PipelineEnvironment> environments = null;
    @SerializedName(value="options")
    private V1alpha1PipelineOptions options = null;
    @SerializedName(value="parameters")
    private List<V1alpha1PipelineParameter> parameters = null;
    @SerializedName(value="post")
    private Map<String, List<V1alpha1PipelineTemplateTask>> post = null;
    @SerializedName(value="stages")
    private List<V1alpha1PipelineStage> stages = new ArrayList<V1alpha1PipelineStage>();
    @SerializedName(value="triggers")
    private V1alpha1PipelineTriggers triggers = null;
    @SerializedName(value="values")
    private V1alpha1ConstValues values = null;
    @SerializedName(value="withSCM")
    private Boolean withSCM = null;

    public V1alpha1PipelineTemplateSpec agent(V1alpha1JenkinsAgent agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(value="Agent indicate where the pipeline will running")
    public V1alpha1JenkinsAgent getAgent() {
        return this.agent;
    }

    public void setAgent(V1alpha1JenkinsAgent agent) {
        this.agent = agent;
    }

    public V1alpha1PipelineTemplateSpec arguments(List<V1alpha1PipelineTemplateArgumentGroup> arguments) {
        this.arguments = arguments;
        return this;
    }

    public V1alpha1PipelineTemplateSpec addArgumentsItem(V1alpha1PipelineTemplateArgumentGroup argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroup>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @ApiModelProperty(value="Arguments is arguments for templates")
    public List<V1alpha1PipelineTemplateArgumentGroup> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<V1alpha1PipelineTemplateArgumentGroup> arguments) {
        this.arguments = arguments;
    }

    public V1alpha1PipelineTemplateSpec engine(String engine) {
        this.engine = engine;
        return this;
    }

    @ApiModelProperty(required=true, value="Engine the way how to render PipelineTemplate")
    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public V1alpha1PipelineTemplateSpec environments(List<V1alpha1PipelineEnvironment> environments) {
        this.environments = environments;
        return this;
    }

    public V1alpha1PipelineTemplateSpec addEnvironmentsItem(V1alpha1PipelineEnvironment environmentsItem) {
        if (this.environments == null) {
            this.environments = new ArrayList<V1alpha1PipelineEnvironment>();
        }
        this.environments.add(environmentsItem);
        return this;
    }

    @ApiModelProperty(value="Environments is environment for jenkinsfile")
    public List<V1alpha1PipelineEnvironment> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<V1alpha1PipelineEnvironment> environments) {
        this.environments = environments;
    }

    public V1alpha1PipelineTemplateSpec options(V1alpha1PipelineOptions options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(value="")
    public V1alpha1PipelineOptions getOptions() {
        return this.options;
    }

    public void setOptions(V1alpha1PipelineOptions options) {
        this.options = options;
    }

    public V1alpha1PipelineTemplateSpec parameters(List<V1alpha1PipelineParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1alpha1PipelineTemplateSpec addParametersItem(V1alpha1PipelineParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<V1alpha1PipelineParameter>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @ApiModelProperty(value="Parameters will need before pipeline run")
    public List<V1alpha1PipelineParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<V1alpha1PipelineParameter> parameters) {
        this.parameters = parameters;
    }

    public V1alpha1PipelineTemplateSpec post(Map<String, List<V1alpha1PipelineTemplateTask>> post) {
        this.post = post;
        return this;
    }

    public V1alpha1PipelineTemplateSpec putPostItem(String key, List<V1alpha1PipelineTemplateTask> postItem) {
        if (this.post == null) {
            this.post = new HashMap<String, List<V1alpha1PipelineTemplateTask>>();
        }
        this.post.put(key, postItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, List<V1alpha1PipelineTemplateTask>> getPost() {
        return this.post;
    }

    public void setPost(Map<String, List<V1alpha1PipelineTemplateTask>> post) {
        this.post = post;
    }

    public V1alpha1PipelineTemplateSpec stages(List<V1alpha1PipelineStage> stages) {
        this.stages = stages;
        return this;
    }

    public V1alpha1PipelineTemplateSpec addStagesItem(V1alpha1PipelineStage stagesItem) {
        this.stages.add(stagesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Stages contains all stages of a pipeline script")
    public List<V1alpha1PipelineStage> getStages() {
        return this.stages;
    }

    public void setStages(List<V1alpha1PipelineStage> stages) {
        this.stages = stages;
    }

    public V1alpha1PipelineTemplateSpec triggers(V1alpha1PipelineTriggers triggers) {
        this.triggers = triggers;
        return this;
    }

    @ApiModelProperty(value="")
    public V1alpha1PipelineTriggers getTriggers() {
        return this.triggers;
    }

    public void setTriggers(V1alpha1PipelineTriggers triggers) {
        this.triggers = triggers;
    }

    public V1alpha1PipelineTemplateSpec values(V1alpha1ConstValues values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(value="")
    public V1alpha1ConstValues getValues() {
        return this.values;
    }

    public void setValues(V1alpha1ConstValues values) {
        this.values = values;
    }

    public V1alpha1PipelineTemplateSpec withSCM(Boolean withSCM) {
        this.withSCM = withSCM;
        return this;
    }

    @ApiModelProperty(value="WithSCM indicate if we use scm in Pipeline")
    public Boolean isWithSCM() {
        return this.withSCM;
    }

    public void setWithSCM(Boolean withSCM) {
        this.withSCM = withSCM;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1PipelineTemplateSpec v1alpha1PipelineTemplateSpec = (V1alpha1PipelineTemplateSpec)o;
        return Objects.equals(this.agent, v1alpha1PipelineTemplateSpec.agent) && Objects.equals(this.arguments, v1alpha1PipelineTemplateSpec.arguments) && Objects.equals(this.engine, v1alpha1PipelineTemplateSpec.engine) && Objects.equals(this.environments, v1alpha1PipelineTemplateSpec.environments) && Objects.equals(this.options, v1alpha1PipelineTemplateSpec.options) && Objects.equals(this.parameters, v1alpha1PipelineTemplateSpec.parameters) && Objects.equals(this.post, v1alpha1PipelineTemplateSpec.post) && Objects.equals(this.stages, v1alpha1PipelineTemplateSpec.stages) && Objects.equals(this.triggers, v1alpha1PipelineTemplateSpec.triggers) && Objects.equals(this.values, v1alpha1PipelineTemplateSpec.values) && Objects.equals(this.withSCM, v1alpha1PipelineTemplateSpec.withSCM);
    }

    public int hashCode() {
        return Objects.hash(this.agent, this.arguments, this.engine, this.environments, this.options, this.parameters, this.post, this.stages, this.triggers, this.values, this.withSCM);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1PipelineTemplateSpec {\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    engine: ").append(this.toIndentedString(this.engine)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("    stages: ").append(this.toIndentedString(this.stages)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    withSCM: ").append(this.toIndentedString(this.withSCM)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

