package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateBuilder extends V1alpha1PipelineTemplateFluentImpl<V1alpha1PipelineTemplateBuilder> implements VisitableBuilder<V1alpha1PipelineTemplate,V1alpha1PipelineTemplateBuilder>{

    V1alpha1PipelineTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplate(), validationEnabled);
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplate(), validationEnabled);
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplateFluent<?> fluent,V1alpha1PipelineTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplateFluent<?> fluent,V1alpha1PipelineTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplate instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateBuilder(V1alpha1PipelineTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplate build(){
            V1alpha1PipelineTemplate buildable = new V1alpha1PipelineTemplate();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateBuilder that = (V1alpha1PipelineTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
