package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStatusFluentImpl<A extends V1alpha1PipelineStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineStatusFluent<A>{

    private Boolean aborted;
    private DateTime finishedAt;
    private V1alpha1PipelineStatusJenkinsBuilder jenkins;
    private String phase;
    private DateTime startedAt;
    private DateTime updatedAt;

    public V1alpha1PipelineStatusFluentImpl(){
    }
    public V1alpha1PipelineStatusFluentImpl(V1alpha1PipelineStatus instance){
            this.withAborted(instance.isAborted());

            this.withFinishedAt(instance.getFinishedAt());

            this.withJenkins(instance.getJenkins());

            this.withPhase(instance.getPhase());

            this.withStartedAt(instance.getStartedAt());

            this.withUpdatedAt(instance.getUpdatedAt());

    }

    public Boolean isAborted(){
            return this.aborted;
    }

    public A withAborted(Boolean aborted){
            this.aborted=aborted; return (A) this;
    }

    public Boolean hasAborted(){
            return this.aborted != null;
    }

    public A withNewAborted(String arg1){
            return (A)withAborted(new Boolean(arg1));
    }

    public A withNewAborted(boolean arg1){
            return (A)withAborted(new Boolean(arg1));
    }

    public DateTime getFinishedAt(){
            return this.finishedAt;
    }

    public A withFinishedAt(DateTime finishedAt){
            this.finishedAt=finishedAt; return (A) this;
    }

    public Boolean hasFinishedAt(){
            return this.finishedAt != null;
    }

    public A withNewFinishedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withFinishedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewFinishedAt(Object arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    public A withNewFinishedAt(long arg0){
            return (A)withFinishedAt(new DateTime(arg0));
    }

    
/**
 * This method has been deprecated, please use method buildJenkins instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStatusJenkins getJenkins(){
            return this.jenkins!=null?this.jenkins.build():null;
    }

    public V1alpha1PipelineStatusJenkins buildJenkins(){
            return this.jenkins!=null?this.jenkins.build():null;
    }

    public A withJenkins(V1alpha1PipelineStatusJenkins jenkins){
            _visitables.get("jenkins").remove(this.jenkins);
            if (jenkins!=null){ this.jenkins= new V1alpha1PipelineStatusJenkinsBuilder(jenkins); _visitables.get("jenkins").add(this.jenkins);} return (A) this;
    }

    public Boolean hasJenkins(){
            return this.jenkins != null;
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> withNewJenkins(){
            return new JenkinsNestedImpl();
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> withNewJenkinsLike(V1alpha1PipelineStatusJenkins item){
            return new JenkinsNestedImpl(item);
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editJenkins(){
            return withNewJenkinsLike(getJenkins());
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editOrNewJenkins(){
            return withNewJenkinsLike(getJenkins() != null ? getJenkins(): new V1alpha1PipelineStatusJenkinsBuilder().build());
    }

    public V1alpha1PipelineStatusFluent.JenkinsNested<A> editOrNewJenkinsLike(V1alpha1PipelineStatusJenkins item){
            return withNewJenkinsLike(getJenkins() != null ? getJenkins(): item);
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public DateTime getStartedAt(){
            return this.startedAt;
    }

    public A withStartedAt(DateTime startedAt){
            this.startedAt=startedAt; return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.startedAt != null;
    }

    public A withNewStartedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withStartedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewStartedAt(Object arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public A withNewStartedAt(long arg0){
            return (A)withStartedAt(new DateTime(arg0));
    }

    public DateTime getUpdatedAt(){
            return this.updatedAt;
    }

    public A withUpdatedAt(DateTime updatedAt){
            this.updatedAt=updatedAt; return (A) this;
    }

    public Boolean hasUpdatedAt(){
            return this.updatedAt != null;
    }

    public A withNewUpdatedAt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withUpdatedAt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewUpdatedAt(Object arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public A withNewUpdatedAt(long arg0){
            return (A)withUpdatedAt(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStatusFluentImpl that = (V1alpha1PipelineStatusFluentImpl) o;
            if (aborted != null ? !aborted.equals(that.aborted) :that.aborted != null) return false;
            if (finishedAt != null ? !finishedAt.equals(that.finishedAt) :that.finishedAt != null) return false;
            if (jenkins != null ? !jenkins.equals(that.jenkins) :that.jenkins != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
            if (updatedAt != null ? !updatedAt.equals(that.updatedAt) :that.updatedAt != null) return false;
            return true;
    }


    public class JenkinsNestedImpl<N> extends V1alpha1PipelineStatusJenkinsFluentImpl<V1alpha1PipelineStatusFluent.JenkinsNested<N>> implements V1alpha1PipelineStatusFluent.JenkinsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStatusJenkinsBuilder builder;
    
            JenkinsNestedImpl(V1alpha1PipelineStatusJenkins item){
                    this.builder = new V1alpha1PipelineStatusJenkinsBuilder(this, item);
            }
            JenkinsNestedImpl(){
                    this.builder = new V1alpha1PipelineStatusJenkinsBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineStatusFluentImpl.this.withJenkins(builder.build());
    }
    public N endJenkins(){
            return and();
    }

}


}
