package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineRunLimitsBuilder extends V1alpha1PipelineRunLimitsFluentImpl<V1alpha1PipelineRunLimitsBuilder> implements VisitableBuilder<V1alpha1PipelineRunLimits,V1alpha1PipelineRunLimitsBuilder>{

    V1alpha1PipelineRunLimitsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineRunLimitsBuilder(){
            this(true);
    }
    public V1alpha1PipelineRunLimitsBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineRunLimits(), validationEnabled);
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimitsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimitsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineRunLimits(), validationEnabled);
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimitsFluent<?> fluent,V1alpha1PipelineRunLimits instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimitsFluent<?> fluent,V1alpha1PipelineRunLimits instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFailureCount(instance.getFailureCount());

            fluent.withSuccessCount(instance.getSuccessCount());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimits instance){
            this(instance,true);
    }
    public V1alpha1PipelineRunLimitsBuilder(V1alpha1PipelineRunLimits instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFailureCount(instance.getFailureCount());

            this.withSuccessCount(instance.getSuccessCount());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineRunLimits build(){
            V1alpha1PipelineRunLimits buildable = new V1alpha1PipelineRunLimits();
            buildable.setFailureCount(fluent.getFailureCount());
            buildable.setSuccessCount(fluent.getSuccessCount());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineRunLimitsBuilder that = (V1alpha1PipelineRunLimitsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
