package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1OriginCodeRepositoryBuilder extends V1alpha1OriginCodeRepositoryFluentImpl<V1alpha1OriginCodeRepositoryBuilder> implements VisitableBuilder<V1alpha1OriginCodeRepository,V1alpha1OriginCodeRepositoryBuilder>{

    V1alpha1OriginCodeRepositoryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1OriginCodeRepositoryBuilder(){
            this(true);
    }
    public V1alpha1OriginCodeRepositoryBuilder(Boolean validationEnabled){
            this(new V1alpha1OriginCodeRepository(), validationEnabled);
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepositoryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepositoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1OriginCodeRepository(), validationEnabled);
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepositoryFluent<?> fluent,V1alpha1OriginCodeRepository instance){
            this(fluent, instance, true);
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepositoryFluent<?> fluent,V1alpha1OriginCodeRepository instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCloneURL(instance.getCloneURL());

            fluent.withCodeRepoServiceType(instance.getCodeRepoServiceType());

            fluent.withCreatedAt(instance.getCreatedAt());

            fluent.withData(instance.getData());

            fluent.withDescription(instance.getDescription());

            fluent.withFullName(instance.getFullName());

            fluent.withHtmlURL(instance.getHtmlURL());

            fluent.withId(instance.getId());

            fluent.withLanguage(instance.getLanguage());

            fluent.withName(instance.getName());

            fluent.withOwner(instance.getOwner());

            fluent.withPrivate(instance.isPrivate());

            fluent.withPushedAt(instance.getPushedAt());

            fluent.withSize(instance.getSize());

            fluent.withSizeHumanize(instance.getSizeHumanize());

            fluent.withSshURL(instance.getSshURL());

            fluent.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepository instance){
            this(instance,true);
    }
    public V1alpha1OriginCodeRepositoryBuilder(V1alpha1OriginCodeRepository instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCloneURL(instance.getCloneURL());

            this.withCodeRepoServiceType(instance.getCodeRepoServiceType());

            this.withCreatedAt(instance.getCreatedAt());

            this.withData(instance.getData());

            this.withDescription(instance.getDescription());

            this.withFullName(instance.getFullName());

            this.withHtmlURL(instance.getHtmlURL());

            this.withId(instance.getId());

            this.withLanguage(instance.getLanguage());

            this.withName(instance.getName());

            this.withOwner(instance.getOwner());

            this.withPrivate(instance.isPrivate());

            this.withPushedAt(instance.getPushedAt());

            this.withSize(instance.getSize());

            this.withSizeHumanize(instance.getSizeHumanize());

            this.withSshURL(instance.getSshURL());

            this.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1OriginCodeRepository build(){
            V1alpha1OriginCodeRepository buildable = new V1alpha1OriginCodeRepository();
            buildable.setCloneURL(fluent.getCloneURL());
            buildable.setCodeRepoServiceType(fluent.getCodeRepoServiceType());
            buildable.setCreatedAt(fluent.getCreatedAt());
            buildable.setData(fluent.getData());
            buildable.setDescription(fluent.getDescription());
            buildable.setFullName(fluent.getFullName());
            buildable.setHtmlURL(fluent.getHtmlURL());
            buildable.setId(fluent.getId());
            buildable.setLanguage(fluent.getLanguage());
            buildable.setName(fluent.getName());
            buildable.setOwner(fluent.getOwner());
            buildable.setPrivate(fluent.isPrivate());
            buildable.setPushedAt(fluent.getPushedAt());
            buildable.setSize(fluent.getSize());
            buildable.setSizeHumanize(fluent.getSizeHumanize());
            buildable.setSshURL(fluent.getSshURL());
            buildable.setUpdatedAt(fluent.getUpdatedAt());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1OriginCodeRepositoryBuilder that = (V1alpha1OriginCodeRepositoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
