package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1MultiBranchOrphanBuilder extends V1alpha1MultiBranchOrphanFluentImpl<V1alpha1MultiBranchOrphanBuilder> implements VisitableBuilder<V1alpha1MultiBranchOrphan,V1alpha1MultiBranchOrphanBuilder>{

    V1alpha1MultiBranchOrphanFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1MultiBranchOrphanBuilder(){
            this(true);
    }
    public V1alpha1MultiBranchOrphanBuilder(Boolean validationEnabled){
            this(new V1alpha1MultiBranchOrphan(), validationEnabled);
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphanFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphanFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1MultiBranchOrphan(), validationEnabled);
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphanFluent<?> fluent,V1alpha1MultiBranchOrphan instance){
            this(fluent, instance, true);
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphanFluent<?> fluent,V1alpha1MultiBranchOrphan instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDays(instance.getDays());

            fluent.withMax(instance.getMax());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphan instance){
            this(instance,true);
    }
    public V1alpha1MultiBranchOrphanBuilder(V1alpha1MultiBranchOrphan instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDays(instance.getDays());

            this.withMax(instance.getMax());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1MultiBranchOrphan build(){
            V1alpha1MultiBranchOrphan buildable = new V1alpha1MultiBranchOrphan();
            buildable.setDays(fluent.getDays());
            buildable.setMax(fluent.getMax());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1MultiBranchOrphanBuilder that = (V1alpha1MultiBranchOrphanBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
