package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl<A extends V1alpha1DocumentManagementBindingReplicaTemplateFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1DocumentManagementBindingReplicaTemplateFluent<A>{

    private List<V1alpha1DocumentManagementSpaceRefBuilder> spaces;
    private V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder template;

    public V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl(){
    }
    public V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl(V1alpha1DocumentManagementBindingReplicaTemplate instance){
            this.withSpaces(instance.getSpaces());

            this.withTemplate(instance.getTemplate());

    }

    public A addToSpaces(int index,V1alpha1DocumentManagementSpaceRef item){
            if (this.spaces == null) {this.spaces = new ArrayList<V1alpha1DocumentManagementSpaceRefBuilder>();}
            V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);_visitables.get("spaces").add(index >= 0 ? index : _visitables.get("spaces").size(), builder);this.spaces.add(index >= 0 ? index : spaces.size(), builder); return (A)this;
    }

    public A setToSpaces(int index,V1alpha1DocumentManagementSpaceRef item){
            if (this.spaces == null) {this.spaces = new ArrayList<V1alpha1DocumentManagementSpaceRefBuilder>();}
            V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);
            if (index < 0 || index >= _visitables.get("spaces").size()) { _visitables.get("spaces").add(builder); } else { _visitables.get("spaces").set(index, builder);}
            if (index < 0 || index >= spaces.size()) { spaces.add(builder); } else { spaces.set(index, builder);}
             return (A)this;
    }

    public A addToSpaces(V1alpha1DocumentManagementSpaceRef... items){
            if (this.spaces == null) {this.spaces = new ArrayList<V1alpha1DocumentManagementSpaceRefBuilder>();}
            for (V1alpha1DocumentManagementSpaceRef item : items) {V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);_visitables.get("spaces").add(builder);this.spaces.add(builder);} return (A)this;
    }

    public A addAllToSpaces(Collection<V1alpha1DocumentManagementSpaceRef> items){
            if (this.spaces == null) {this.spaces = new ArrayList<V1alpha1DocumentManagementSpaceRefBuilder>();}
            for (V1alpha1DocumentManagementSpaceRef item : items) {V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);_visitables.get("spaces").add(builder);this.spaces.add(builder);} return (A)this;
    }

    public A removeFromSpaces(V1alpha1DocumentManagementSpaceRef... items){
            for (V1alpha1DocumentManagementSpaceRef item : items) {V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);_visitables.get("spaces").remove(builder);if (this.spaces != null) {this.spaces.remove(builder);}} return (A)this;
    }

    public A removeAllFromSpaces(Collection<V1alpha1DocumentManagementSpaceRef> items){
            for (V1alpha1DocumentManagementSpaceRef item : items) {V1alpha1DocumentManagementSpaceRefBuilder builder = new V1alpha1DocumentManagementSpaceRefBuilder(item);_visitables.get("spaces").remove(builder);if (this.spaces != null) {this.spaces.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSpaces instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1DocumentManagementSpaceRef> getSpaces(){
            return build(spaces);
    }

    public List<V1alpha1DocumentManagementSpaceRef> buildSpaces(){
            return build(spaces);
    }

    public V1alpha1DocumentManagementSpaceRef buildSpace(int index){
            return this.spaces.get(index).build();
    }

    public V1alpha1DocumentManagementSpaceRef buildFirstSpace(){
            return this.spaces.get(0).build();
    }

    public V1alpha1DocumentManagementSpaceRef buildLastSpace(){
            return this.spaces.get(spaces.size() - 1).build();
    }

    public V1alpha1DocumentManagementSpaceRef buildMatchingSpace(io.alauda.devops.java.client.fluent.Predicate<V1alpha1DocumentManagementSpaceRefBuilder> predicate){
            for (V1alpha1DocumentManagementSpaceRefBuilder item: spaces) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSpace(io.alauda.devops.java.client.fluent.Predicate<V1alpha1DocumentManagementSpaceRefBuilder> predicate){
            for (V1alpha1DocumentManagementSpaceRefBuilder item: spaces) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSpaces(List<V1alpha1DocumentManagementSpaceRef> spaces){
            if (this.spaces != null) { _visitables.get("spaces").removeAll(this.spaces);}
            if (spaces != null) {this.spaces = new ArrayList<V1alpha1DocumentManagementSpaceRefBuilder>(); for (V1alpha1DocumentManagementSpaceRef item : spaces){this.addToSpaces(item);}} else { this.spaces = null;} return (A) this;
    }

    public A withSpaces(V1alpha1DocumentManagementSpaceRef... spaces){
            if (this.spaces != null) {this.spaces.clear();}
            if (spaces != null) {for (V1alpha1DocumentManagementSpaceRef item :spaces){ this.addToSpaces(item);}} return (A) this;
    }

    public Boolean hasSpaces(){
            return spaces != null && !spaces.isEmpty();
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> addNewSpace(){
            return new SpacesNestedImpl();
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> addNewSpaceLike(V1alpha1DocumentManagementSpaceRef item){
            return new SpacesNestedImpl(-1, item);
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> setNewSpaceLike(int index,V1alpha1DocumentManagementSpaceRef item){
            return new SpacesNestedImpl(index, item);
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> editSpace(int index){
            if (spaces.size() <= index) throw new RuntimeException("Can't edit spaces. Index exceeds size.");
            return setNewSpaceLike(index, buildSpace(index));
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> editFirstSpace(){
            if (spaces.size() == 0) throw new RuntimeException("Can't edit first spaces. The list is empty.");
            return setNewSpaceLike(0, buildSpace(0));
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> editLastSpace(){
            int index = spaces.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last spaces. The list is empty.");
            return setNewSpaceLike(index, buildSpace(index));
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<A> editMatchingSpace(io.alauda.devops.java.client.fluent.Predicate<V1alpha1DocumentManagementSpaceRefBuilder> predicate){
            int index = -1;
            for (int i=0;i<spaces.size();i++) { 
            if (predicate.apply(spaces.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching spaces. No match found.");
            return setNewSpaceLike(index, buildSpace(index));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1DocumentManagementBindingReplicaTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1alpha1DocumentManagementBindingReplicaTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplateLike(V1alpha1DocumentManagementBindingReplicaTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder().build());
    }

    public V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplateLike(V1alpha1DocumentManagementBindingReplicaTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl that = (V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl) o;
            if (spaces != null ? !spaces.equals(that.spaces) :that.spaces != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class SpacesNestedImpl<N> extends V1alpha1DocumentManagementSpaceRefFluentImpl<V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<N>> implements V1alpha1DocumentManagementBindingReplicaTemplateFluent.SpacesNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1DocumentManagementSpaceRefBuilder builder;
        private final int index;
    
            SpacesNestedImpl(int index,V1alpha1DocumentManagementSpaceRef item){
                    this.index = index;
                    this.builder = new V1alpha1DocumentManagementSpaceRefBuilder(this, item);
            }
            SpacesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1DocumentManagementSpaceRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl.this.setToSpaces(index, builder.build());
    }
    public N endSpace(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1alpha1DocumentManagementBindingReplicaTemplateSpecFluentImpl<V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<N>> implements V1alpha1DocumentManagementBindingReplicaTemplateFluent.TemplateNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1alpha1DocumentManagementBindingReplicaTemplateSpec item){
                    this.builder = new V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1alpha1DocumentManagementBindingReplicaTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1DocumentManagementBindingReplicaTemplateFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
