/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import com.google.common.util.concurrent.AtomicLongMap;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;

public class ItemFastSlowRateLimiter<T>
implements RateLimiter<T> {
    private Duration fastDelay;
    private Duration slowDelay;
    private int maxFastAttempts;
    private AtomicLongMap<T> failures;

    public ItemFastSlowRateLimiter(Duration fastDelay, Duration slowDelay, int maxFastAttempts) {
        this.fastDelay = fastDelay;
        this.slowDelay = slowDelay;
        this.maxFastAttempts = maxFastAttempts;
        this.failures = AtomicLongMap.create();
    }

    @Override
    public Duration when(T item) {
        long attempts = this.failures.incrementAndGet(item);
        if (attempts <= (long)this.maxFastAttempts) {
            return this.fastDelay;
        }
        return this.slowDelay;
    }

    @Override
    public void forget(T item) {
        this.failures.remove(item);
    }

    @Override
    public int numRequeues(T item) {
        return (int)this.failures.get(item);
    }
}

