/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.alauda.devops.java.client.extend.workqueue.WorkQueue;
import java.util.LinkedList;
import java.util.Set;

public class DefaultWorkQueue<T>
implements WorkQueue<T> {
    private LinkedList<T> queue = Lists.newLinkedList();
    private Set<T> dirty = Sets.newHashSet();
    private Set<T> processing = Sets.newHashSet();
    private boolean shuttingDown = false;

    @Override
    public synchronized void add(T item) {
        if (this.shuttingDown) {
            return;
        }
        if (this.dirty.contains(item)) {
            return;
        }
        this.dirty.add(item);
        if (this.processing.contains(item)) {
            return;
        }
        this.queue.add(item);
        this.notify();
    }

    @Override
    public synchronized int length() {
        return this.queue.size();
    }

    @Override
    public synchronized T get() throws InterruptedException {
        while (this.queue.size() == 0 && !this.shuttingDown) {
            this.wait();
        }
        if (this.queue.size() == 0) {
            return null;
        }
        T obj = this.queue.poll();
        this.processing.add(obj);
        this.dirty.remove(obj);
        return obj;
    }

    @Override
    public synchronized void done(T item) {
        this.processing.remove(item);
        if (this.dirty.contains(item)) {
            this.queue.add(item);
            this.notify();
        }
    }

    @Override
    public synchronized void shutDown() {
        this.shuttingDown = true;
        this.notifyAll();
    }

    @Override
    public synchronized boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

