/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.controller.builder;

import io.alauda.devops.java.client.extend.controller.Controllers;
import io.alauda.devops.java.client.extend.controller.DefaultControllerWatch;
import io.alauda.devops.java.client.extend.controller.reconciler.Request;
import io.alauda.devops.java.client.extend.workqueue.WorkQueue;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class ControllerWatchBuilder<ApiType> {
    private Function<ApiType, Request> workKeyGenerator;
    private WorkQueue<Request> workQueue = null;
    private Class<ApiType> apiTypeClass;
    private Predicate<ApiType> onAddFilterPredicate;
    private BiPredicate<ApiType, ApiType> onUpdateFilterPredicate;
    private BiPredicate<ApiType, Boolean> onDeleteFilterPredicate;

    ControllerWatchBuilder(Class<ApiType> apiTypeClass) {
        this.apiTypeClass = apiTypeClass;
        this.workKeyGenerator = Controllers.defaultReflectiveKeyFunc();
    }

    public ControllerWatchBuilder<ApiType> withOnAddFilter(Predicate<ApiType> filter) {
        this.onAddFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withOnUpdateFilter(BiPredicate<ApiType, ApiType> filter) {
        this.onUpdateFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withOnDeleteFilter(BiPredicate<ApiType, Boolean> filter) {
        this.onDeleteFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withWorkQueueKeyFunc(Function<ApiType, Request> workKeyGenerator) {
        this.workKeyGenerator = workKeyGenerator;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withWorkQueue(WorkQueue<Request> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public DefaultControllerWatch<ApiType> build() throws IllegalStateException {
        if (null == this.workQueue) {
            throw new IllegalStateException("work-queue must not be null when building work-queue event handler..");
        }
        DefaultControllerWatch<ApiType> workQueueHandler = new DefaultControllerWatch<ApiType>(this.apiTypeClass, this.workQueue, this.workKeyGenerator);
        if (this.onAddFilterPredicate != null) {
            workQueueHandler.setOnAddFilterPredicate(this.onAddFilterPredicate);
        }
        if (this.onUpdateFilterPredicate != null) {
            workQueueHandler.setOnUpdateFilterPredicate(this.onUpdateFilterPredicate);
        }
        if (this.onDeleteFilterPredicate != null) {
            workQueueHandler.setOnDeleteFilterPredicate(this.onDeleteFilterPredicate);
        }
        return workQueueHandler;
    }
}

