/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import io.alauda.devops.java.client.extend.workqueue.ratelimiter.ItemExponentialFailureRateLimiter;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class ItemExponentialFailureRateLimiterTest {
    @Test
    public void testItemExponentialFailureRateLimiter() {
        ItemExponentialFailureRateLimiter rateLimiter = new ItemExponentialFailureRateLimiter(Duration.ofMillis(1L), Duration.ofSeconds(1L));
        Assert.assertEquals((Object)Duration.ofMillis(1L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(2L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(4L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(8L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(16L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((long)5L, (long)rateLimiter.numRequeues((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(1L), (Object)rateLimiter.when((Object)"two"));
        Assert.assertEquals((Object)Duration.ofMillis(2L), (Object)rateLimiter.when((Object)"two"));
        Assert.assertEquals((long)2L, (long)rateLimiter.numRequeues((Object)"two"));
        rateLimiter.forget((Object)"one");
        Assert.assertEquals((long)0L, (long)rateLimiter.numRequeues((Object)"one"));
        Assert.assertEquals((Object)Duration.ofMillis(1L), (Object)rateLimiter.when((Object)"one"));
    }

    @Test
    public void testItemExponentialFailureRateLimiterOverFlow() {
        int i;
        ItemExponentialFailureRateLimiter rateLimiter = new ItemExponentialFailureRateLimiter(Duration.ofMillis(1L), Duration.ofSeconds(1000L));
        for (i = 0; i < 5; ++i) {
            rateLimiter.when((Object)"one");
        }
        Assert.assertEquals((Object)Duration.ofMillis(32L), (Object)rateLimiter.when((Object)"one"));
        for (i = 0; i < 1000; ++i) {
            rateLimiter.when((Object)"overflow1");
        }
        Assert.assertEquals((Object)Duration.ofSeconds(1000L), (Object)rateLimiter.when((Object)"overflow1"));
        rateLimiter = new ItemExponentialFailureRateLimiter(Duration.ofMinutes(1L), Duration.ofHours(1000L));
        for (i = 0; i < 2; ++i) {
            rateLimiter.when((Object)"two");
        }
        Assert.assertEquals((Object)Duration.ofMinutes(4L), (Object)rateLimiter.when((Object)"two"));
        for (i = 0; i < 1000; ++i) {
            rateLimiter.when((Object)"overflow2");
        }
        Assert.assertEquals((Object)Duration.ofHours(1000L), (Object)rateLimiter.when((Object)"overflow2"));
    }

    @Test
    public void testNegativeBaseDelay() {
        int i;
        ItemExponentialFailureRateLimiter rateLimiter = new ItemExponentialFailureRateLimiter(Duration.ofMillis(-1L), Duration.ofSeconds(1000L));
        for (i = 0; i < 5; ++i) {
            rateLimiter.when((Object)"one");
        }
        Assert.assertEquals((Object)Duration.ofMillis(-32L), (Object)rateLimiter.when((Object)"one"));
        for (i = 0; i < 1000; ++i) {
            rateLimiter.when((Object)"overflow1");
        }
        Assert.assertTrue((boolean)rateLimiter.when((Object)"overflow1").isNegative());
    }

    @Test
    public void testNegativeMaxDelay() {
        ItemExponentialFailureRateLimiter rateLimiter = new ItemExponentialFailureRateLimiter(Duration.ofMillis(1L), Duration.ofSeconds(-1000L));
        Assert.assertEquals((Object)Duration.ofSeconds(-1000L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(-1000L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(-1000L), (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ofSeconds(-1000L), (Object)rateLimiter.when((Object)"one"));
    }
}

