/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import io.alauda.devops.java.client.extend.workqueue.ratelimiter.BucketRateLimiter;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BucketRateLimiterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBucketRateLimiterBasic() {
        BucketRateLimiter rateLimiter = new BucketRateLimiter(2L, 1L, Duration.ofMinutes(10L));
        Assert.assertEquals((Object)Duration.ZERO, (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ZERO, (Object)rateLimiter.when((Object)"one"));
        Duration waitDuration = rateLimiter.when((Object)"one");
        Duration expectDuration = Duration.ofMinutes(10L);
        Duration diff = waitDuration.minus(expectDuration);
        Assert.assertTrue((diff.isZero() || diff.isNegative() && !diff.plusSeconds(1L).isNegative() ? 1 : 0) != 0);
        waitDuration = rateLimiter.when((Object)"one");
        expectDuration = Duration.ofMinutes(20L);
        diff = waitDuration.minus(expectDuration);
        Assert.assertTrue((diff.isZero() || diff.isNegative() && !diff.plusSeconds(1L).isNegative() ? 1 : 0) != 0);
    }

    @Test
    public void testBucketRateLimiterTokenAdded() throws InterruptedException {
        BucketRateLimiter rateLimiter = new BucketRateLimiter(2L, 1L, Duration.ofSeconds(2L));
        Assert.assertEquals((Object)Duration.ZERO, (Object)rateLimiter.when((Object)"one"));
        Assert.assertEquals((Object)Duration.ZERO, (Object)rateLimiter.when((Object)"one"));
        Duration waitDuration = rateLimiter.when((Object)"one");
        Assert.assertTrue((waitDuration.getSeconds() > 0L ? 1 : 0) != 0);
        Thread.sleep(4000L);
        Assert.assertEquals((Object)Duration.ZERO, (Object)rateLimiter.when((Object)"two"));
        waitDuration = rateLimiter.when((Object)"two");
        Assert.assertTrue((waitDuration.getSeconds() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeCapacity() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("-2 is wrong value for capacity, because capacity should be positive");
        BucketRateLimiter rateLimiter = new BucketRateLimiter(-2L, 1L, Duration.ofSeconds(2L));
    }

    @Test
    public void testNegativeTokensGeneratedInPeriod() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("-1 is wrong value for period tokens, because tokens should be positive");
        BucketRateLimiter rateLimiter = new BucketRateLimiter(2L, -1L, Duration.ofSeconds(2L));
    }

    @Test
    public void testNegativePeriod() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("-1 is wrong value for period of bandwidth, because period should be positive");
        BucketRateLimiter rateLimiter = new BucketRateLimiter(2L, 1L, Duration.ofNanos(-1L));
    }

    @Test
    public void testTokensLargerThanNanos() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("100 token/nanosecond is not permitted refill rate, because highest supported rate is 1 token/nanosecond");
        BucketRateLimiter rateLimiter = new BucketRateLimiter(2L, 100L, Duration.ofNanos(1L));
    }
}

