/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue;

import io.alauda.devops.java.client.extend.wait.Wait;
import io.alauda.devops.java.client.extend.workqueue.DefaultDelayingQueue;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDelayingQueueTest {
    @Test
    public void testSimpleDelayingQueue() throws Exception {
        DefaultDelayingQueue queue = new DefaultDelayingQueue();
        queue.addAfter((Object)"foo", Duration.ofMillis(50L));
        Assert.assertTrue((boolean)this.waitForWaitingQueueToFill(queue));
        Assert.assertTrue((queue.length() == 0 ? 1 : 0) != 0);
        Thread.sleep(60L);
        Assert.assertTrue((boolean)this.waitForAdded(queue, 1));
        String item = (String)queue.get();
        queue.done((Object)item);
        Thread.sleep(10000L);
        Assert.assertTrue((queue.length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeduping() throws Exception {
        DefaultDelayingQueue queue = new DefaultDelayingQueue();
        String item = "foo";
        queue.addAfter((Object)item, Duration.ofMillis(50L));
        Assert.assertTrue((boolean)this.waitForWaitingQueueToFill(queue));
        queue.addAfter((Object)item, Duration.ofMillis(70L));
        Assert.assertTrue((boolean)this.waitForWaitingQueueToFill(queue));
        Assert.assertTrue((String)"should not have added", (queue.length() == 0 ? 1 : 0) != 0);
        Thread.sleep(60L);
        Assert.assertTrue((boolean)this.waitForAdded(queue, 1));
        item = (String)queue.get();
        queue.done((Object)item);
        Thread.sleep(20L);
        Assert.assertTrue((String)"should not have added", (queue.length() == 0 ? 1 : 0) != 0);
        queue.addAfter((Object)item, Duration.ofMillis(50L));
        queue.addAfter((Object)item, Duration.ofMillis(30L));
        Assert.assertTrue((boolean)this.waitForWaitingQueueToFill(queue));
        Assert.assertTrue((String)"should not have added", (queue.length() == 0 ? 1 : 0) != 0);
        Thread.sleep(40L);
        Assert.assertTrue((boolean)this.waitForAdded(queue, 1));
        item = (String)queue.get();
        queue.done((Object)item);
        Thread.sleep(1L);
        Assert.assertTrue((String)"should not have added", (queue.length() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCopyShifting() throws Exception {
        DefaultDelayingQueue queue = new DefaultDelayingQueue();
        String first = "foo";
        String second = "bar";
        String third = "baz";
        queue.addAfter((Object)"foo", Duration.ofSeconds(1L));
        queue.addAfter((Object)"bar", Duration.ofMillis(500L));
        queue.addAfter((Object)"baz", Duration.ofMillis(250L));
        Assert.assertTrue((boolean)this.waitForWaitingQueueToFill(queue));
        Assert.assertTrue((String)"should not have added", (queue.length() == 0 ? 1 : 0) != 0);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.waitForAdded(queue, 3));
        String actualFirst = (String)queue.get();
        Assert.assertEquals((Object)actualFirst, (Object)"baz");
        String actualSecond = (String)queue.get();
        Assert.assertEquals((Object)actualSecond, (Object)"bar");
        String actualThird = (String)queue.get();
        Assert.assertEquals((Object)actualThird, (Object)"foo");
    }

    private boolean waitForAdded(DefaultDelayingQueue queue, int size) {
        return Wait.poll((Duration)Duration.ofMillis(10L), (Duration)Duration.ofSeconds(10L), () -> queue.length() == size);
    }

    private boolean waitForWaitingQueueToFill(DefaultDelayingQueue queue) {
        return Wait.poll((Duration)Duration.ofMillis(10L), (Duration)Duration.ofSeconds(10L), () -> queue.waitingForAddQueue.size() == 0);
    }
}

