package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolBindingMapBuilder extends V1alpha1ToolBindingMapFluentImpl<V1alpha1ToolBindingMapBuilder> implements VisitableBuilder<V1alpha1ToolBindingMap,V1alpha1ToolBindingMapBuilder>{

    V1alpha1ToolBindingMapFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolBindingMapBuilder(){
            this(true);
    }
    public V1alpha1ToolBindingMapBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolBindingMap(), validationEnabled);
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMapFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMapFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolBindingMap(), validationEnabled);
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMapFluent<?> fluent,V1alpha1ToolBindingMap instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMapFluent<?> fluent,V1alpha1ToolBindingMap instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMap instance){
            this(instance,true);
    }
    public V1alpha1ToolBindingMapBuilder(V1alpha1ToolBindingMap instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolBindingMap build(){
            V1alpha1ToolBindingMap buildable = new V1alpha1ToolBindingMap();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolBindingMapBuilder that = (V1alpha1ToolBindingMapBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
